/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	AboutDialog.h
 *
 *****************************************************************************/

// SOL++2000
// 1999.09.25 Modified

// 2000.02.18


#include <sol\ApplicationView.h>
#include <sol\ScrolledText.h>
#include <sol\ModalDialog.h>
#include <sol\Text.h>
#include <sol\ListBox.h>
#include "resource.h"


class FileDlg : public ModalDialog {
	Text*    text;
	ListBox* listbox;
	void	changeDir(Action& action);
	long	initDialog(Event& event);
 public:
	FileDlg() : ModalDialog() { }
 	FileDlg(View* parent, const char* caption, Args& args);
	~FileDlg();
	void	getFileName(char* fileName, int size);
};


void FileDlg::changeDir(Action& action)
{
	char dir[128];
	WPARAM attribute = DDL_READWRITE|DDL_READONLY|DDL_HIDDEN |\
		    DDL_SYSTEM|DDL_ARCHIVE|DDL_DIRECTORY;

	text -> getText(dir, sizeof(dir));

	char pattern[128];
	sprintf(pattern, "%s\\*.*", dir);
	listbox -> resetContent();
	listbox -> dir(attribute, pattern);
}


FileDlg::FileDlg(View* parent, const char* caption, Args& args)
	:ModalDialog(parent, caption,
			args.set(XmNtemplateName, "FileName"))
{

	text    = NULL;
	listbox = NULL;

}


FileDlg::~FileDlg()
{
	if(text)	delete text;
	if(listbox) delete listbox; 
}

long FileDlg::initDialog(Event& event)
{
	if(text)    delete text;
	if(listbox) delete listbox;

	text    = new Text(this, getItem(IDC_EDIT));
	listbox = new ListBox(this, getItem(IDC_LIST));
	text -> setFocus();
	text -> addCallback(XmNactivateCallback, this,
			(Callback)&FileDlg::changeDir, NULL);

	return NULL;
}


void FileDlg::getFileName(char* fileName, int size)
{
	char* dir = text -> getText();
	char* file = listbox -> getCurText();	
	*fileName = Zero;
	if(dir && file) {
		sprintf(fileName, "%s\\%s", dir, file);
	}
	delete [] dir;
	delete [] file;
}



class AppView :public ApplicationView {
	FileDlg*	fileDlg;
	ScrolledText   text;
	void		ok(Action& action);
  public:
	AppView(Application& applet, const char* name, Args& args);
	~AppView() { delete fileDlg; }
};
 

// 
void AppView::ok(Action& action)
{
	char fileName[256];
	fileDlg->getFileName(fileName, sizeof(fileName));
  	text.load(fileName);
}


AppView::AppView(Application& applet, const char* name, Args& args)
		:ApplicationView(applet, name, args)
{
	Args ar;
	ar.set(XmNtemplateName, "FileName");
 	fileDlg = new FileDlg(this, NULL, ar);

	ar.reset();
	text.create(this, "", ar);
	// 1999.09.25
	add(text);

	addCallback(XmNmenuCallback, ID_OPEN, fileDlg,
			(Callback)&ModalDialog::popup, NULL);

	addCallback(XmNmenuCallback, ID_EXIT, this,
			(Callback)&AppView::exit, NULL);

	fileDlg->addCallback(XmNactivateCallback, IDOK, this,
			(Callback)&AppView::ok, NULL);
}


void	Main(int argc, char** argv)
{
	const char* appClass = "AppView";
	Application applet(appClass, argc, argv);

	Args args;
	AppView appView(applet, appClass, args);
	appView.realize();

	applet.run();
}

