/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ListView.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18


#include <sol\ApplicationView.h>
#include <sol\FileDialog.h>
#include <sol\ListView.h>
#include <sol\StringTokenizer.h>
#include <sol\Stdio.h>

class AppView :public ApplicationView {
	ListView	listview;
	FileDialog  filedlg;
	Boolean     hasHeader;

	void	open(Action& action);
  public:
	AppView(Application& applet, const char* label, Args& args);
};


AppView::AppView(Application& applet, const char* label, Args& args)
        :ApplicationView(applet, label, args)
{
	Args ar;
	ar.set(XmNexStyle, (ulong)WS_EX_CLIENTEDGE);
	ar.set(XmNstyle, (ulong)LVS_REPORT);
	listview.create(this, "", ar);

	// 1999.09.15 Modified. 
	add(listview);
	hasHeader = False;
	addCallback(XmNmenuCallback, 100, this, (Callback)&AppView::open, NULL);
	addCallback(XmNmenuCallback, 101, this, (Callback)&AppView::exit, NULL);
		
	ar.reset();
	filedlg.create(this, "Open", ar);		
}

void AppView::open(Action& action)
{
	filedlg.popup(action);
	if(action.getResult()) {
		listview.clear();

		const char* fileName = filedlg.getFileName();
		FileStream stream;

		if(stream.openReadOnly(fileName)) {
			char line[512];
			StringList list;
			int n = -1;
			while(stream.getLine(line, sizeof(line)-1)) {
				const char* ptr = line;
				if(line[0] == ';') continue;	// comment line
				if(strlen(line) == 0) {
					continue;	// empty line
				}

				list.clear();

				// 1999.09.23
				char token[128];
				StringTokenizer scanner(line);
				while(ptr) {
					token[0] = Zero;
					ptr = scanner.getToken(token, sizeof(token));
					if (strlen(token) >0) {
						list.add(new String(token));
					}
				}

				if (list.getLength() == 0) {
					continue;
				}

				if(n == -1) {
					if (hasHeader == False) {
						listview.setColumn(&list);
						hasHeader = True;
					}
				}
				else {
					listview.insertLine(n, &list);
				}
				n++;
			}
			stream.close();
		}
	}
}


void	Main(int argc, char** argv)
{
	const char* name = "ListView";
	Application applet(name, argc, argv);

	Args args;
	AppView appview(applet, name, args);
	appview.realize();

	applet.run();
}

