/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ImageTransform.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.06.18

#include <sol\ApplicationView.h>
#include <sol\PaintDC.h>
#include <sol\ClientDC.h>
#include <sol\DIBSection.h>
#include <sol\AffineTransform.h>


class ImageTransform :public ApplicationView {
	DIBSection	 baseImage;
	DIBSection*  rotatedImage;
	DIBSection*  translatedImage;
	int		num;

	void createBaseImage(DC cdc) {
		num = 255;
		baseImage.create(cdc, num, num);
		for (int r = 0; r<num; r++) {
			for(int g = 0; g<num; g++) {
			int b = 255;
				baseImage.setPixel(g, r, RGB(r, g, b));
			}
		}
		// Draw text string into a MemoryDC of the baseImage .
		DC dc = baseImage.getDC();
		const char* string = "SOL++2000";
		dc.textOut(20, 30, string, strlen(string));
	}

	long paint(Event& event)
	{
		PaintDC pdc(this);
		baseImage.draw(pdc, 11, 11);

		if (rotatedImage) {
			rotatedImage->draw(pdc, 11+num+30, 11);	
		}
		if (translatedImage) {
			translatedImage->draw(pdc, 11, 11+num+30);
		}
		return 0;
	}

  public:
	ImageTransform(Application& applet, const char* label, Args& args)
		:ApplicationView(applet, label, args)
	{
		ClientDC cdc(this);

		// Create a baseImage by using DIBSection class.
		createBaseImage(cdc);

		AffineTransform transform;

		// Create a rotatedImage from baseImage by using AffineTransform class.
		rotatedImage = transform.rotate(cdc, baseImage, 30.0);

		// Create a translatedImage from baseImage by using AffineTransform class.
		translatedImage = transform.translate(cdc, baseImage, 50, 20);
	
		addEventHandler(WM_PAINT, this, (Handler)&ImageTransform::paint, null);
	}

	~ImageTransform() {
		delete rotatedImage;
		delete translatedImage;
	}
};


void	Main(int argc, char** argv)
{
	const char* name = "ImageTransform";
	Application applet(name, argc, argv);

	Args args;
	args.set(XmNwidth, 660);
	args.set(XmNheight, 580);
	ImageTransform imageTransform(applet, name, args);
	imageTransform.realize();
	applet.run();
}
