/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	HotKey.cpp
 *
 *****************************************************************************/


// SOL++2000 
// 2000.02.18

#include <sol\ApplicationView.h>
#include <sol\FileDialog.h>
#include <sol\RichText.h>
#include <sol\HotKey.h>


class AppView :public ApplicationView {
	FileDialog	filedlg;
    HotKey		hotKey;
    RichText	richText;
    void    open(Action& action);
	long	size(Event& event);
	long	sysCommand(Event& event);
  public:
	AppView(Application& applet, const char* label, Args& args);
};


void AppView::open(Action& action)
{
	filedlg.popup(action);
	if(action.getResult()) {
		char* name = filedlg.getFileName();
		if(name) {
			richText.load(name);
		}
	}
}

long AppView::size(Event& event)
{
	LPARAM l = event.getLParam();
	richText.reshape(2, 40, LOWORD(l)-4, HIWORD(l)-40-2);
	return NULL;
}


AppView::AppView(Application& applet, const char* label, 
				 Args& args)
		:ApplicationView(applet, label, args)
{
	Args ar;
	 
	ar.set(XmNstyle, (ulong)WS_VSCROLL|ES_AUTOVSCROLL|ES_MULTILINE);
	richText.create(this, "", ar);

	ar.reset();
	ar.set(XmNx,     2);
	ar.set(XmNy,      2);
	ar.set(XmNwidth,  100);
	ar.set(XmNheight, 30);
	ar.set(XmNexStyle, (ulong)WS_EX_WINDOWEDGE);
	hotKey.create(this, "", ar);
	WORD keyComb =	MAKEWORD('X', HOTKEYF_CONTROL);
	hotKey.setHotKey('X', HOTKEYF_CONTROL);		

	send(WM_SETHOTKEY, keyComb, 0);

	ar.reset();
	ar.set(XmNfilter, (ulong)"(All Files *.*)\0 *.*\0");
	filedlg.create(this, "Open", ar);

	addCallback(XmNmenuCallback, 100, this, (Callback)&AppView::open, NULL);
	addCallback(XmNmenuCallback, 101, this, (Callback)&AppView::exit, NULL);

	addEventHandler(WM_SYSCOMMAND, this, (Handler)&AppView::sysCommand, NULL);
}

long AppView::sysCommand(Event& event)
{
	if(event.getWParam() == SC_HOTKEY) {
		show(SW_MINIMIZE);
		return NULL;
	}
	else {
		return defaultProc(event);
	}
}

void	Main(int argc, char** argv)
{
    const char* name = "HotKey";
	Application applet(name, argc, argv);

	Args args;
	AppView appView(applet, name, args);
	appView.realize();

	applet.run();
}

