/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	HTMLReader.h
 *
 *****************************************************************************/

// SOL++2000 Sample
// 2000/11/11


#ifndef _SOL_SCROLLEDRICHTEXT
#include <sol\ScrolledRichText.h>
#endif

#ifndef _SOL_STRING
#include <sol\String.h>
#endif


#ifndef _SOL_THREAD
#include <sol\Thread.h>
#endif


#ifndef _SOL_URL
#include <sol\URL.h>
#endif

#ifndef _SOL_HTMLREADER
#define _SOL_HTMLREADER

class HTMLReader : public Thread {
	URL			url;
	String			proxyHost;
	unsigned short	proxyPort;
	char		urlString[256];

	ScrolledRichText*	richText;

	void	readReply(SocketStream* sock);

	void	handleHttp();
	void	readFile();

 public:
	HTMLReader(ScrolledRichText* richText, char* u);
	HTMLReader(ScrolledRichText* richText, char* u, 
			const char* host, unsigned short port);

	void	run();
};

#endif


