/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Dirtreev.cpp
 *
 *****************************************************************************/


// SOL++2000 
// 2000.02.18

#include "dirtreev.h"


DirTreeView::DirTreeView(View* parent, const char* name, Args& args)
	:TreeView(parent, name, args)
{
}


Boolean DirTreeView::create(View* parent, const char* name, Args& args)
{	
	return TreeView::create(parent, name, args);

}

void DirTreeView::findDirectories(HTREEITEM parent, char* dir,
				  int level, int max)
{
	if(level < max) {
		WIN32_FIND_DATA data;
		HTREEITEM item = (HTREEITEM)TVI_FIRST;

		char* buffer = new char[_MAX_PATH];
		sprintf(buffer, "%s\\*", dir);
		HANDLE fFile= ::FindFirstFile(buffer, &data);

		if(fFile != INVALID_HANDLE_VALUE) {
			do {
				if (data.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
					if (strcmp(".", data.cFileName) != 0 && 
						strcmp("..", data.cFileName) != 0) {
						item = addItem(parent, item, data.cFileName);
						char* subDir = new char[_MAX_PATH];
						sprintf(subDir, "%s\\%s", dir, data.cFileName);
						// Go to next level of trees.
						findDirectories(item, subDir, (level+1), max);
						delete subDir;
					}
				}
			} while(::FindNextFile(fFile, &data)); 
			::FindClose(fFile);
		}
		delete buffer;
	}
}

// Delete all children and siblings
void DirTreeView::deleteChildren(HTREEITEM htreeItem)
{
	HTREEITEM child = getChild(htreeItem);
	while(child) {
		HTREEITEM sibling = getNextSibling(child);
		deleteItem(child);
		child = sibling;
	}
}

// Get fullpathname
void DirTreeView::getHierachy(HTREEITEM selItem, char* buff, char* delim)
{
	TV_ITEM hitem;

	HTREEITEM parent = getParent(selItem);
	if(parent) {
		//
		getHierachy(parent, buff, delim);
		char* text       = new char[_MAX_PATH];
		hitem.mask       = TVIF_TEXT|TVIF_HANDLE;
		hitem.hItem      = selItem;
		hitem.pszText    = text;
		hitem.cchTextMax = _MAX_PATH;
		getItem(&hitem);
		strcat(buff, delim);
		strcat(buff, text);
		delete [] text;
	}
	else {
		char* text       = new char[_MAX_PATH];
		hitem.mask       = TVIF_TEXT|TVIF_HANDLE;
		hitem.hItem      = selItem;
		hitem.pszText    = text;
		hitem.cchTextMax = _MAX_PATH;
		getItem(&hitem);
		strcat(buff, text);
		delete [] text;
	}
}
