/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ExCombo.cpp
 *
 *****************************************************************************/


// SOL++2000 
// 2000.02.18

#include <sol\ApplicationView.h>
#include <sol\ListBox.h>
#include <sol\Directory.h>
#include <sol\StringTokenizer.h>
#include <sol\ExtendedComboBox.h>
#include "resource.h"


class MainView :public ApplicationView {
	ExtendedComboBox comboBox;
	ListBox			listbox;

	void	selected(Action& action);
	long	size(Event& event);

  public:
	MainView(Application& applet, const char* name, Args& args);
};


MainView::MainView(Application& applet, const char* name, Args& args)
	:ApplicationView(applet, name, args)
{
	Args ar;
	ar.set(XmNstyle, (ulong)CBS_DROPDOWNLIST);
	ar.set(XmNheight, 100);
	comboBox.create(this, "", ar);

	comboBox.addCallback(XmNselChangeCallback, this, 
				(Callback)&MainView::selected, null);

	char buff[_MAX_PATH];

	Directory dir;
	dir.getCwd(buff, sizeof(buff));

	COMBOBOXEXITEM item;
	memset(&item, 0, sizeof(item));
	item.mask= CBEIF_TEXT|CBEIF_INDENT;

	StringTokenizer tokenizer(buff);
	tokenizer.clearSeparator();
	tokenizer.addSeparator('\\');

	const char* ptr = buff;
	int n = 0;

	while (tokenizer.hasMoreToken()) {
		char text[100];
		ptr = tokenizer.getToken(text, sizeof(text));
		item.pszText = text;
		item.cchTextMax = strlen(text);
		item.iItem      = n;
		item.iIndent    = n;
		comboBox.insertItem(&item);
		n++;
	}

	ar.reset();
	listbox.create(this, "", ar);
}


void MainView::selected(Action& action)
{
	COMBOBOXEXITEM item;
	memset(&item, 0, sizeof(item));
	item.mask= CBEIF_TEXT|CBEIF_INDENT;
	int n = comboBox.getCurSel();
	StringBuffer dir;
	for (int i = 0; i<=n; i++) {
		char text[100];
		item.pszText = text;
		item.cchTextMax = sizeof(text);
		item.iItem      = i;
		comboBox.getItem(&item);
		dir.append(text);
		dir.append("\\");
	}
	dir.append("*.*");
	setText(dir.getBuffer());
	listbox.clear();
	listbox.findFiles(dir.getBuffer());
}


long MainView::size(Event& event)
{
	int w, h;
	event.getSize(w, h);
	int h1 = comboBox.get(XmNheight);
	comboBox.reshape(0, 0, w, h1);
	listbox.reshape(0, h1+2, w, h-h1-4);
	return 0L;
}


// MainView Main
void	Main(int argc, char** argv)
{
	const char* appClass = "MainView";
	Application applet(appClass, argc, argv);
		
	Args args;
	args.set(XmNbackground, (COLOR_BTNFACE+1));
	MainView mainView(applet, appClass, args);
	mainView.realize();
	applet.run();
}

