/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	DropClient.cpp
 *
 *****************************************************************************/


// SOL++2000 
// 2000.02.18


#include <sol\ApplicationView.h>
#include <sol\PaintDC.h>
#include <sol\DropFiles.h>


class DropClient :public ApplicationView {
	char string[256];
	long dropFiles(Event& event) 
	{
		char fileName[256];
		DropFiles drop((HDROP)event.getWParam());
		fileName[0] = Zero;
		int num = drop.queryFile(0, fileName, sizeof(fileName));
		POINT pt;
		drop.queryPoint(&pt);
		if(num > 0) {
			sprintf(string, "Pos %d %d name %s", 
				(short)pt.x, (short)pt.y, fileName);
			setText(string);	
			update(NULL);
		}
		return NULL;
	}

	long paint(Event& event)
	{
		PaintDC pdc(this);
		if(string[0] != Zero) {
			pdc.textOut(10, 10, string, strlen(string));
		}
		return NULL;
	}

  public:
	DropClient(Application& applet, const char* label, Args& args)
		:ApplicationView(applet, label, 
				args.set(XmNexStyle,(ulong)WS_EX_ACCEPTFILES))
	{
		string[0] = Zero;
		addEventHandler(WM_PAINT, this, (Handler)&DropClient::paint, NULL);
		addEventHandler(WM_DROPFILES, this, (Handler)&DropClient::dropFiles, NULL);
	}
};


void	Main(int argc, char** argv)
{
	const char* appClass = "DropClient";
	Application applet(appClass, argc, argv);

	Args args;
	DropClient dropClient(applet, appClass, args);
	dropClient.realize();

	applet.run();
}

