/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	DragServer.cpp
 *
 *****************************************************************************/


// SOL++2000 
// 2000.02.18

// SOL++2000
// 1999.09.25 Modified.
// Select an item in  the fileList, and press a mouse pointer
// in a clinet area outsidef of the listbox and drag the pointer
// to a droppable target window,  such a title bar of notepad.

#include <sol\ApplicationView.h>
#include <shlobj.h>
#include <sol\PushButton.h>
#include <sol\stdio.h>
#include <sol\DropFiles.h>
#include <sol\FileListBox.h>
#include <sol\Directory.h>
#include <sol\Static.h>


class DragServer :public ApplicationView {
	BOOL	capturing;
	FileListBox fileList;
	long	leftButtonUp(Event& event);
	long	leftButtonDown(Event& event);
	long	mouseMove(Event& event);
    BOOL	isDroppable(HWND target);
	Static	description;

public:
	DragServer(Application& applet, const char*label, Args& args);
};
	

BOOL DragServer::isDroppable(HWND target)
{
	BOOL rc = FALSE;
	if(::IsWindow(target) && (target != getWindow()) ) {
		DWORD style = ::GetWindowLong(target, GWL_EXSTYLE);
	   if(style && WS_EX_ACCEPTFILES) {
		   rc = TRUE;
	   }
	}
	return rc;
}


long DragServer::leftButtonUp(Event& event)
{
	POINT pt;
	event.getMousePosition(&pt);

	toScreen(&pt);
	HWND target = ::WindowFromPoint(pt);

	char name[_MAX_PATH];
	
	if(::IsWindow(target) && fileList.getCurText(name) >0) {
		::ScreenToClient(target, &pt);
		Directory dir;
		char buff[_MAX_PATH];
		dir.getCwd(buff, sizeof(buff));
		String path = buff;
		path = path + "\\";
		path = path + name;
		StringList stringList;
		Printf("Path %s\r\n", (const char*)path);
		stringList.add(new String(path));

		DropFiles dropFiles(&stringList, pt, FALSE);
		int max =		dropFiles.queryCount();
		Printf("GetCount %d \r\n", max);
	  
		for(int i = 0; i<max; i++) {
			Printf("GetFileNameLength %d\r\n",
				dropFiles.queryFileNameLength(i));
			char name[_MAX_PATH];
			dropFiles.queryFile(i, name, sizeof(name));
			Printf("QueryFile  %s\r\n",	name);
		}
		::BringWindowToTop(target);
		::SendMessage(target, WM_DROPFILES, 
			(WPARAM)dropFiles.getDropHandle(), NULL);
	}

	ReleaseCapture();
	capturing = FALSE;

	return NULL;
}


long DragServer::mouseMove(Event& event) 
{
	if(capturing) {
		POINT p;
		event.getMousePosition(&p);
		toScreen(&p);

		HWND parent = ::WindowFromPoint(p);
		if(::IsWindow(parent)) {
			DWORD pstyle = ::GetWindowLong(parent, GWL_EXSTYLE);
			::ScreenToClient(parent, &p);
			HWND target = ::ChildWindowFromPoint(parent, p);
				
			DWORD style = ::GetWindowLong(target,GWL_EXSTYLE);
			Printf("Pos  %d %d\r\n", (short) p.x, (short)p.y);
			// 1999.09.25 Modified.
			if((style & WS_EX_ACCEPTFILES) ||
			   (pstyle & WS_EX_ACCEPTFILES) ){
				::SetCursor(LoadCursor(NULL, IDC_ARROW));
			}
			else {
				::SetCursor(LoadCursor(NULL, IDC_NO)); 
			}
		}
		else {
			::SetCursor(LoadCursor(NULL, IDC_NO)); 
		}
	}
	return NULL;
}


long DragServer::leftButtonDown(Event& event)
{
	capturing = TRUE;
	capture();

	return NULL;
}

	  
DragServer::DragServer(Application& applet, const char* label, Args& args)
	:ApplicationView(applet, label, args)
{
	capturing = FALSE;
	Args ar;
	ar.set(XmNx, 10);
	ar.set(XmNy, 10);
	ar.set(XmNstyle, (ulong)SS_SUNKEN);
	description.create(this, "Select a file, and start a dragging here.", ar);

	ar.reset();
	fileList.create(this, "", ar);
//	add(fileList);
	
	fileList.reshape(10, 60, 200, 200);
	fileList.update();

	addEventHandler(WM_LBUTTONDOWN, this, (Handler)&DragServer::leftButtonDown, NULL);
	addEventHandler(WM_MOUSEMOVE, this, (Handler)&DragServer::mouseMove, NULL);

	addEventHandler(WM_LBUTTONUP, this,  (Handler)&DragServer::leftButtonUp, NULL);
}



void	Main(int argc, char** argv)
{
	static char* appClass = "DropFileServer";
	Application applet(appClass, argc, argv);

	Args args;
	args.set(XmNwidth,  400);
	args.set(XmNheight, 300);
	args.set(XmNbackground, (ulong)(COLOR_BTNFACE+1));
	DragServer appview(applet, appClass, args);
	appview.realize();

	applet.run();
}

