/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ClassBrowser.cpp
 *
 *****************************************************************************/


// SOL++2000 
// 2000.02.18



#include <sol\ApplicationView.h>
#include <sol\DirectoryDialog.h>
#include "resource.h"

class AppView :public ApplicationView {
    DirectoryDialog     dirdlg;

	void	selectDir(Action& action)
	{
		dirdlg.popup(action);
		if (action.getResult()) {
			char* dir = dirdlg.getDir();
			setText(dir);
		}
	}

  public:
	AppView(Application& applet, const char* name, Args& args)
		:ApplicationView(applet, name, args)
	{
		Args ar;
		dirdlg.create(this, "DirectoryDialog", ar);

		addCallback(XmNmenuCallback, ID_DIR, this, (Callback)&AppView::selectDir, null);
		addCallback(XmNmenuCallback, ID_EXIT, this, (Callback)&AppView::exit, null);
	}
};


// AppView Main
void	Main(int argc, char** argv)
{
	const char* name = "AppView";
	Application applet(name, argc, argv);
	Args args;
	AppView appview(applet, name, args);
	appview.realize();
	applet.run();   
}

