/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ColorModel.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.06.15

#include <sol\ApplicationView.h>
#include <sol\PaintDC.h>
#include <sol\ClientDC.h>
#include <sol\DIBSection.h>

#define WM_CREATE_COLORS	(WM_USER+200)


class ColorModel :public ApplicationView {
	DIBSection colorSpace;
	int			num;

	long	createColors(Event& event) {
		ClientDC cdc(this);
		
		num = 256;
		colorSpace.create(cdc, num*2, num*2);
		colorSpace.clear();

		for (int r = 0; r<num; r++) {
			for(int g = 0; g<num; g++) {
				for(int b = 0; b<num; b++) {
					colorSpace.setPixel(b + r,g + r, RGB(r, g, b));
				}
			}
		}
		return 0;
	}

	long paint(Event& event)
	{
		PaintDC pdc(this);
		pdc.rectangle(10, 10, 10+num*2+2, 10+num*2+2);
		colorSpace.draw(pdc, 11, 11);
		return 0;
	}

  public:
	ColorModel(Application& applet, const char* label, Args& args)
		:ApplicationView(applet, label, args)
	{

		addCallback(XmNmenuCallback, 1000, this, (Callback)&ColorModel::exit, NULL);

		addEventHandler(WM_PAINT, this, (Handler)&ColorModel::paint, null);
		addEventHandler(WM_CREATE_COLORS, this, (Handler)&ColorModel::createColors, null);

		post(WM_CREATE_COLORS, 0, 0);
	}
};


void	Main(int argc, char** argv)
{
	const char* name = "ColorModel";
	Application applet(name, argc, argv);

	Args args;
	args.set(XmNwidth, 540);
	args.set(XmNheight, 580);
	args.set(XmNexStyle, (ulong)WS_EX_CLIENTEDGE);
	ColorModel colorModel(applet, name, args);
	colorModel.realize();
	applet.run();
}
