/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ClassTreeView.cpp
 *
 *****************************************************************************/


// SOL++2000 
// 2000.02.18


#include <sol\Object.h>
#include <sol\TreeView.h>
#include <sol\ApplicationView.h>
#include <sol\Font.h>
#include <sol\StringTokenizer.h>
#include <sol\Node.h>
#include <sol\LinkedList.h>
#include <sol\DirectoryDialog.h>
#include <sol\FileStream.h>
#include <sol\ScrolledRichText.h>
#include <sol\SplitPane.h>

#include "InheritanceTreeView.h"

#ifndef _SOL_CLASSTREEVIEW
#define _SOL_CLASSTREEVIEW

class ClassTreeView :public ApplicationView {
	Node*       root;
	LinkedList* pairList;
	Font		font;
	DirectoryDialog dirDlg;
	ScrolledRichText richText;

	InheritanceTreeView treev;
	SplitPane	hpanedw;
	int		initialized;
	char	classLibrary[MAX_PATH];

	long	close(Event& event);
	long	size(Event& event);
	void	selectDir(Action& action);
	void	selChanged(Action& action);
	
	void	buildTree(HTREEITEM hitem, char* name);
	void	expandChildren(HTREEITEM htreeItem, int flag);
    int		findClass(char* dir);
    int		searchClass(char* name);
	void	dumpPairList();

	void	startup(char* dir);

 public:
	ClassTreeView(Application& applet, const char* name, Args& args);
	~ClassTreeView();
};

#endif
