/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Brush.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.16


#include <sol\ApplicationView.h>
#include <sol\PaintDC.h>
#include <sol\Brush.h>
#include <sol\StockObject.h>


class AppView :public ApplicationView {
	long	paint(Event& event);

  public:
	AppView(Application& applet, const char* label, Args& args);
};


long AppView::paint(Event& event)
{
	PaintDC pdc(this);
	RECT	r;
	getClientRect(&r);
	int w = r.bottom/255+1;
	StockObject pen(NULL_PEN);
	pdc.select(&pen);
	for(int i = 0; i < 255; i++) {
		Brush* brush = new Brush(RGB(0, 0, 255-i) );
		HGDIOBJ prev = pdc.select(brush);
		pdc.rectangle(100+i, 100, 200+i, 200);
		pdc.select(prev);
		delete brush;
	}
	return 0L;
}


AppView::AppView(Application& applet, const char* label, Args& args)
	:ApplicationView(applet, label, args)
{
	addEventHandler(WM_PAINT, this, (Handler)&AppView::paint, null);
}


void	Main(int argc, char** argv)
{
	const char* name = "Brush";
	Application applet(name, argc, argv);

	Args args;
	AppView appview(applet, name, args);
	appview.realize();
	applet.run();
}
