/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	BitmapViewer.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.16


#include <sol\ApplicationView.h>
#include <sol\BitmapFile.h>
#include <sol\Bitmap.h>
#include <sol\PaintDC.h>
#include <sol\ClientDC.h>
#include <sol\FileDialog.h>


class BitmapViewer :public ApplicationView {
	Bitmap*	       bitmap;

	FileDialog		fileDialog;
	void	updateScrollRange();
	long	paint(Event& event);
	void	open(Action& action);
	void	load(Action& action);
	long	size(Event& event);
  public:
	BitmapViewer(Application& applet, const char* name, Args& args);
	~BitmapViewer();
};


BitmapViewer::BitmapViewer(Application& applet, const char* name, Args& args)
	:ApplicationView(applet, name,
		args.set(XmNstyle, (ulong)WS_VSCROLL|WS_HSCROLL)),
	bitmap(null)
{
	addEventHandler(WM_PAINT, this,
			(Handler)&BitmapViewer::paint, NULL);
	addCallback(XmNmenuCallback, 1000, this,
			(Callback)&BitmapViewer::open, NULL);
	addCallback(XmNmenuCallback, 1001, this,
			(Callback)&BitmapViewer::exit, NULL);

	Args ar;
	ar.set(XmNfilter, "(BitmapFiles *.bmp)\0 *.bmp\0");
	fileDialog.create(this, "", ar);
}


BitmapViewer::~BitmapViewer()
{
	delete bitmap;
}


void BitmapViewer::open(Action& action)
{
	if(fileDialog.open()){
		char title[256];
		char* filename = fileDialog.getFileName();

		ClientDC cdc(this);
		BitmapFile file;
		if(file.openReadOnly(filename) == TRUE) {
			HBITMAP hbitmap = file.extract(cdc.get());
			file.close();
			if(hbitmap) {
				if(bitmap) delete bitmap;
				bitmap = new Bitmap(filename, hbitmap);
				sprintf(title, "%s - BitmapViewer", filename);
				setText(title);
				setScrollPos(HORIZONTAL, 0);
				setScrollPos(VERTICAL, 0);
				updateScrollRange();
				update();
			}
		}
	}
}


void BitmapViewer::updateScrollRange()
{
	if (bitmap) {
		int bw, bh;
		bitmap->getSize(bw, bh); 	
		setScrollExtent(bw, bh);
	}
}


long BitmapViewer::size(Event& event)
{
	if(bitmap) {
		updateScrollRange();
	}
	return NULL;
}


long BitmapViewer::paint(Event& event)
{
	PaintDC pdc(this);

	if(bitmap) {
		int x = getScrollPos(Composite::HORIZONTAL);
		int y = getScrollPos(Composite::VERTICAL);
		bitmap -> setSource(x, y);
		bitmap -> draw(pdc, 0, 0);
	}
	return NULL;
}



void	Main(int argc, char** argv)
{
	const char* appClass = "BitmapViewer";
	Application applet(appClass, argc, argv);

	Args args;
	BitmapViewer bitmapView(applet, appClass, args);
	bitmapView.realize();

	applet.run();
}

