/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Animator.cpp
 *
 *****************************************************************************/


// SOL++2000
// 1999.09.25

// 2000.02.16

#include <sol\ApplicationView.h>
#include <sol\FileDialog.h>
#include <sol\PushButton.h>
#include <sol\Animator.h>


class AppView :public ApplicationView {
	Animator  animator;
	PushButton playb;
	PushButton stopb;

	FileDialog filedlg;
	void	open(Action& action);
	void	play(Action& action);
	void	stop(Action& action);

  public:
	AppView(Application& applet, const char* label, Args& args);
	~AppView();
};


void AppView::open(Action& action)
{
	if(filedlg.open() == IDOK) {
		char* name = filedlg.getFileName();
		if(name) {		
			animator.close();
			animator.open(name);
			playb.enable();
			char title[MAX_PATH*2];
			sprintf(title, "%s - Animator", name);
			setText(title);
		}
	}
}

void AppView::play(Action& action)
{
	animator.play(0, -1, -1);
	playb.disable();
	stopb.enable();
}

void AppView::stop(Action& action)
{
	animator.stop();
	stopb.disable();
	playb.enable();
}

AppView::AppView(Application& applet, const char* label, Args& args)
		:ApplicationView(applet, label, args)
{
	Args ar;
	ar.set(XmNx, 10);
	ar.set(XmNy, 10);
	playb.create(this, "Play", ar);
	playb.addCallback(XmNactivateCallback, this, (Callback)&AppView::play, NULL);
	playb.disable();

	ar.reset();
	ar.set(XmNx, 120);
	ar.set(XmNy, 10);
	stopb.create(this, "Stop", ar);
	stopb.addCallback(XmNactivateCallback, this, (Callback)&AppView::stop, NULL);
	stopb.disable();

	ar.reset();
	ar.set(XmNx,     10);
	ar.set(XmNy,      50);
	ar.set(XmNwidth,  200);
	ar.set(XmNheight, 200);
	ar.set(XmNexStyle, (ulong)WS_EX_WINDOWEDGE);
	animator.create(this, "animator", ar);

	ar.reset();
	// 1999.09.25
	ar.set(XmNfilter, (ulong)"(AVI *.avi)\0 *.avi\0");
	filedlg.create(this, "Open", ar);

	addCallback(XmNmenuCallback, 100, this, (Callback)&AppView::open, NULL);
	addCallback(XmNmenuCallback, 101, this, (Callback)&AppView::exit, NULL);

}

AppView::~AppView() 
{ 
	animator.close();
}


void	Main(int argc, char** argv)
{
	const char* appClass = "Animator";
	Application applet(appClass, argc, argv);

	Args args;
	AppView appView(applet, appClass, args);
	appView.realize();
	applet.run();
}

