/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	RowColumn.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\RowColumn.h>
#include <sol\ClientDC.h>


static const long STYLE = WS_CHILD|WS_VISIBLE;


RowColumn::RowColumn(View* parent, const char* name, Args& args)
	:Composite(parent, name, 
		args.set(XmNclassStyle, NULL)
		    .set(XmNstyle, (ulong)STYLE)
		    .set(XmNclassName, "RowColumn"))
{
	margin  = 4;
	spacing = 4;
	column  = 2;
	addEventHandler(WM_SIZE, this,
			(Handler)&RowColumn::size, NULL);
	setValues(args);
}


Boolean RowColumn::create(View* parent, const char* name, Args& args)
{
	Boolean rc = Composite::create(parent, name, 
		args.set(XmNclassStyle, NULL)
		    .set(XmNstyle, (ulong)STYLE)
		    .set(XmNclassName, "RowColumn"));

	margin  = 4;
	spacing = 4;
	column  = 2;
	addEventHandler(WM_SIZE, this,
			(Handler)&RowColumn::size, NULL);
	setValues(args);

	return rc;
}


void	RowColumn::setValues(Args& args)
{
	ulong  val;
	if (args.get(XmNmargin, &val))
		margin = (int)val;
	if (args.get(XmNspacing, &val))
		spacing = (int)val;
	if (args.get(XmNcolumn, &val))
		column = (int)val;
}


long	RowColumn::size(Event& event)
{
	LPARAM lParam = event.getLParam();
	int  w = LOWORD(lParam);
	int  h = HIWORD(lParam);

	ClientDC cdc(this);
	char*  label = "A";
	Size size;
	cdc.getTextExtent(label, strlen(label), &size);
	int  ch = size.cy*3/2;

	int  cw = (w-margin)/column;

	int  num = 0;
	int  x = margin;
	int  y = margin;

	HWND self = getWindow();
	HWND child = ::GetWindow(self, GW_CHILD);
	while(child) {
		if(num >0 && (num%column)== 0) {
			y = y + ch + spacing;
		}
		x = margin + cw * (num % column);
		::MoveWindow(child, x, y, cw-margin, ch, FALSE);
		child = ::GetWindow(child, GW_HWNDNEXT);
		num++;
	}
	update();
	return NULL;
}

