/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	RichText.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\RichText.h>

RichText::RichText(View* parent, const char* name, Args& args)
	:Text(parent, name, 
			args.set(XmNexStyle, (ulong)WS_EX_CLIENTEDGE)
			    .set(XmNpredefined, TRUE)
				.set(XmNclassName, "RICHEDIT"))
{
}


Boolean RichText::create(View* parent, const char* name, Args& args)
{
	return Text::create(parent, name, 
			args.set(XmNexStyle, (ulong)WS_EX_CLIENTEDGE)
			    .set(XmNpredefined, TRUE)
				.set(XmNclassName, "RICHEDIT"));

}


Arg* RichText::getCallbackTable(int* num)
{
	static Arg table[] = {
	// WM_COMMAND
	{XmNchangeCallback,		EN_CHANGE},
	{XmNerrorSpaceCallback,	EN_ERRSPACE},
	{XmNhorizScrollCallback, EN_HSCROLL},
	{XmNkillFocusCallback,	EN_KILLFOCUS},
	{XmNmaxTextCallback,	EN_MAXTEXT},
	{XmNsetFocusCallback,	EN_SETFOCUS},
	{XmNupdateCallback,		EN_UPDATE},
	{XmNvertScrollCallback,	EN_VSCROLL},

	// WM_NOTIFY 
	{XmNcorrectTextCallback, EN_CORRECTTEXT},
	{XmNdropFilesCallback,   EN_DROPFILES},
//	{XmNimeChangeCallback,	 EN_IMECHANGE},
	{XmNmsgFilterCallback,	 EN_MSGFILTER},
	{XmNprotectedCallback,   EN_PROTECTED},
	{XmNrequestResizeCallback, EN_REQUESTRESIZE},
	{XmNstopNoUndoCallback,    EN_STOPNOUNDO},
	{XmNselChangeCallback,   EN_SELCHANGE},
	};
	*num = XtNumber(table);
	return table;
}


void RichText::add(const char* string)
{
	int len = getTextLength();
	CHARRANGE range;
	range.cpMin = len;
	range.cpMax = len;
	//SetSel(len, len);
	exSetSel(&range);
	replaceSel(string);

	len = getTextLength();
	range.cpMin = len;
	range.cpMax = len;

	//SetSel(len, len);
	exSetSel(&range);
	replaceSel("\r\n");
	send(WM_SETREDRAW, 1, 0L);
}

// no \r\n.
void RichText::append(const char* string)
{
	int len = getTextLength();
	CHARRANGE range;
	range.cpMin = len;
	range.cpMax = len;
	//SetSel(len, len);
	exSetSel(&range);

	replaceSel(string);
	send(WM_SETREDRAW, 1, 0L);
}


DWORD CALLBACK RichText::streamInProc(DWORD dwCookies, 
						LPBYTE buff, LONG cb, LONG* pcb)
{
	HANDLE hfile = (HANDLE)dwCookies;
	::ReadFile(hfile, buff, cb, (unsigned long*)pcb, NULL);
	if(*pcb <= 0) {
		*pcb = 0;
	}
	return 0;
}


BOOL RichText::streamIn(const char* filename, UINT format)
{
	File file;
	if(file.openReadOnly(filename)) {
		EDITSTREAM es;
		es.dwCookie = (DWORD)file.getHandle();
		es.dwError = 0;
		es.pfnCallback = (EDITSTREAMCALLBACK)&RichText::streamInProc;
		send(EM_STREAMIN, (WPARAM)format, (LPARAM)&es);
			
		file.close();
		return TRUE;
	}	
	return FALSE ;
}


DWORD CALLBACK RichText::streamOutProc(DWORD dwCookies, 
						LPBYTE buff, LONG cb, LONG* pcb)
{
	HANDLE hfile = (HANDLE)dwCookies;
	::WriteFile(hfile, buff, cb, (unsigned long*)pcb, NULL);
	if(*pcb <= 0){
		*pcb = 0;
	}
	return 0;
}


BOOL RichText::streamOut(const char* filename, UINT format)
{
	File file;
	if(file.create(filename)) {
		EDITSTREAM es;
		es.dwCookie = (DWORD)file.getHandle();
		es.dwError = 0;
		es.pfnCallback = (EDITSTREAMCALLBACK)&RichText::streamOutProc;
		send(EM_STREAMOUT, (WPARAM)format, (LPARAM)&es);
			
		file.close();
		return TRUE;
	}	
	return FALSE;
}

