/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Resource.h
 *
 *****************************************************************************/

// SOL++2000
//2000.06.15 Added a new draw method.

#ifndef _SOL_OBJECT
#include <sol\Object.h>
#endif

#ifndef _SOL_RESOURCE
#define _SOL_RESOURCE

class DC;

class Resource :public Object {
	char*	name;
	HANDLE	handle;
 
 public:
	Resource(const char* name1, HANDLE handle1);
	~Resource(); 
	
	void	setHandle(HANDLE h) { handle = h; }

	virtual	void	draw(HDC hdc, int x, int y) { }

	//<added date="2000.06.15">
	virtual void	draw(DC& dc,  int x, int y) { }
	//</added>

	HANDLE		get()     { return handle; }
	char*		getName() { return name; }
	virtual void	getSize(int* width, int* height) { }
	virtual void	invert() { }
	virtual void	normalize() { }
};

#endif

