/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ReplaceDialog.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.01.07 Modified replace method to check the string length of each
//  arguments
// 2000.01.09 Modified getValue method to set val variable to (ulong*).
 
#include <sol\Application.h>
#include <sol\ReplaceDialog.h>


ReplaceDialog::ReplaceDialog(View* parent, const char* name, Args& args)
	:CommonDialog(parent, new FINDREPLACE)
{
	findString    = new char[MAX_LEN];
	findString[0] = Zero;
	replaceString    = new char[MAX_LEN];
	replaceString[0] = Zero;

	FINDREPLACE* fr = get();
	memset(fr, 0, sizeof(FINDREPLACE));
	fr -> lStructSize = sizeof(FINDREPLACE);

	if(parent) {
		fr -> hwndOwner = parent -> getWindow();
	}

	fr -> hInstance = Application::getInstance();

	fr -> lpstrFindWhat = findString;
	fr -> wFindWhatLen  = MAX_LEN;
	fr -> lpstrReplaceWith = replaceString;
	fr -> wReplaceWithLen  = MAX_LEN;

	setValues(args);
}


ReplaceDialog::~ReplaceDialog() 
{
	FINDREPLACE* fr = get();

	if(fr -> lpfnHook) {
		FreeProcInstance((FARPROC)fr -> lpfnHook);
	}
	delete [] findString;
	delete [] replaceString;
	delete fr;
}



Boolean ReplaceDialog::create(View* parent, const char* name, Args& args)
{
	Boolean rc = True;
	CommonDialog::create(parent, new FINDREPLACE);

	findString    = new char[MAX_LEN];
	findString[0] = Zero;
	replaceString    = new char[MAX_LEN];
	replaceString[0] = Zero;

	FINDREPLACE* fr = get();
	memset(fr, 0, sizeof(FINDREPLACE));
	fr -> lStructSize = sizeof(FINDREPLACE);

	if(parent) {
		fr -> hwndOwner = parent -> getWindow();
	}

	fr -> hInstance = Application::getInstance();

	fr -> lpstrFindWhat = findString;
	fr -> wFindWhatLen  = MAX_LEN;
	fr -> lpstrReplaceWith = replaceString;
	fr -> wReplaceWithLen  = MAX_LEN;

	setValues(args);

	return rc;
}


void ReplaceDialog::replace(const char* find, const char* replace)
{
	// <added date="2000.01.07">
	const char* find1 = "";
	if (find) {
		find1 = find;
	}
	const char* replace1 = "";
	if (replace) {
		replace1 = replace;
	}

	if (strlen(find1) >= MAX_LEN || strlen(replace1)>=MAX_LEN) {
	//	MessageDialog(NULL, "Find string or Replace string is too long",
	//		"ReplaceDialog", MB_OK);
		return;
	}
	// </added>

	strcpy(findString, find1);
	strcpy(replaceString, replace1);

	FINDREPLACE* fr = get();
	setWindow(::ReplaceText(fr));
}


void ReplaceDialog::getValues(Args& args)
{
	FINDREPLACE* fr = get();
	ulong* val = NULL;
	int num   = args.getCount();
	Arg* arg  = args.getArgList();

	for(int i = 0; i<num; i++) {
		const char* name = arg[i].name;
		// <modified date="2000.01.09"> 
		val = (ulong*)arg[i].value;
		// </modified>
		if(name == XmNflags) {
			*val = (ulong)fr->Flags;
			continue;
		}
		if(name == XmNfindString) {
			*val = (ulong)findString;
			continue;
		}
		if(name == XmNreplaceString) {
			*val = (ulong)replaceString;
			continue;
		}
	}
}


void ReplaceDialog::setValues(Args& args)
{
	FINDREPLACE* fr = get();
	ulong val;
	if(args.get(XmNflags, &val)) {
		fr -> Flags |= (DWORD)val;
	}
	if(args.get(XmNhook, &val)) {
		fr -> Flags |= FR_ENABLEHOOK;
		if(fr -> lpfnHook)
				FreeProcInstance((FARPROC)fr -> lpfnHook);
		fr -> lpfnHook = (HOOKFUN)MakeProcInstance((FARPROC)val,
					fr -> hInstance);
	}
	if(args.get(XmNfindString, &val)) {
		char* string = (char*)val;
		if(strlen(string) >= MAX_LEN) {
			*(string+MAX_LEN-1) = NULL;
		}
		strcpy(findString, string);
	}
	if(args.get(XmNreplaceString, &val)) {
		char* string = (char*)val;
		if(strlen(string) >= MAX_LEN) {
			*(string+MAX_LEN-1) = NULL;
		}
		strcpy(replaceString, string);
	}
}

