/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	PromptDialog.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\PromptDialog.h>
#include <sol\ClientDC.h>


long PromptDialog::size(Event& event)
{
	int w, h;
	event.getSize(w, h);

	ClientDC cdc(this);
	int h1 = cdc.getTextHeight() * 7/4;
	int w1 = (w - 40)/3;

	textf .reshape(10, 10, w-20, h1);
	ok    .reshape(20, h-h1-10, w1, h1);
	cancel.reshape(20+w1*2, h-h1-10, w1, h1);

	update(NULL);

	return NULL;
}


PromptDialog::PromptDialog(View* parent, const char* label, Args& args)
	:PopupView(parent, label, 
				args.set(XmNstyle, (ulong)WS_THICKFRAME))
{
	Args ar;
	textf.create(this, "", ar);

	ar.reset();
	ar.set(XmNid, IDOK);
	ok.create(this, "Ok", ar);

	ar.reset();
	ar.set(XmNid, IDCANCEL);
	cancel.create(this, "Cancel", ar);
	cancel.addCallback(XmNactivateCallback, this, 
				(Callback)&PromptDialog::popdown, NULL);

	addEventHandler(WM_SIZE, this,
			(Handler)&PromptDialog::size, NULL);
	resize();
}


PromptDialog::~PromptDialog()
{
}


Boolean PromptDialog::create(View* parent, const char* label, Args& args)
{
	Boolean rc = PopupView::create(parent, label, 
				args.set(XmNstyle, (ulong)WS_THICKFRAME));

	Args ar;
	textf.create(this, "", ar);

	ar.reset();
	ar.set(XmNid, IDOK);
	ok.create(this, "Ok", ar);

	ar.reset();
	ar.set(XmNid, IDCANCEL);
	cancel.create(this, "Cancel", ar);
	cancel.addCallback(XmNactivateCallback, this, 
				(Callback)&PromptDialog::popdown, NULL);

	addEventHandler(WM_SIZE, this,
			(Handler)&PromptDialog::size, NULL);
	resize();

	return rc;
}



void PromptDialog::popup(Action& action)
{
	textf.setSel(0, 256);
	textf.setFocus();
	PopupView::popup(action);
}

