/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	PrintDialog.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.01.09 Modified getValues method.

#include <sol\PrintDialog.h>


PrintDialog::PrintDialog(View* parent, const char* name, Args& args)
	:CommonDialog(parent, new PRINTDLG)
{
	PRINTDLG* pd = get();
	memset(pd, 0, sizeof(PRINTDLG));
	pd -> lStructSize = sizeof(PRINTDLG);
	pd -> hwndOwner = parent -> getWindow();
	pd -> Flags     = PD_RETURNDC;

	pd -> hInstance = parent -> getInstanceHandle();

	setValues(args);
}


PrintDialog::~PrintDialog() 
{
	PRINTDLG* pd = get();
	if (pd -> lpfnPrintHook) {
		FreeProcInstance((FARPROC)pd -> lpfnPrintHook);
	}
	delete pd;
}


Boolean PrintDialog::create(View* parent, const char* name, Args& args)
{
	Boolean rc = CommonDialog::create(parent, new PRINTDLG);

	PRINTDLG* pd = get();
	memset(pd, 0, sizeof(PRINTDLG));
	pd -> lStructSize = sizeof(PRINTDLG);
	pd -> hwndOwner = parent -> getWindow();
	pd -> Flags     = PD_RETURNDC;

	pd -> hInstance = parent -> getInstanceHandle();

	setValues(args);

	return rc;
}


void PrintDialog::getValues(Args& args)
{
	PRINTDLG* pd = get();
	ulong* val = NULL;
	int num   = args.getCount();
	Arg* arg  = args.getArgList();

	for (int i = 0; i<num; i++) {
		const char* name = arg[i].name;
		//<modified date="2000.01.09">
		val = (ulong*)arg[i].value;
		//</modified>

		if(name == XmNflags) {
			*val = (ulong)pd->Flags;
			continue;
		}
		if(name == XmNdc) {
			*val = (ulong)pd -> hDC;
			continue;
		}
	}
}


void PrintDialog::setValues(Args& args)
{
	PRINTDLG* pd = get();
	ulong val;
	if (args.get(XmNhook, &val)) {
		pd -> Flags |= PD_ENABLEPRINTHOOK;
		if(pd -> lpfnPrintHook)
			FreeProcInstance((FARPROC)pd -> lpfnPrintHook);
		pd -> lpfnPrintHook = 
			(HOOKFUN)MakeProcInstance((FARPROC)val,
				pd -> hInstance);
	}
	if (args.get(XmNtemplateName, &val)) {
		pd -> Flags |= PD_ENABLEPRINTTEMPLATE;
		pd -> lpPrintTemplateName  = (char*)val;
	}
	if (args.get(XmNflags, &val)) {
		pd ->Flags |= (DWORD)val;
	}
}


void PrintDialog::popup(Action& action)
{
	int result = print();
	action.setResult(result);
}

