/******************************************************************************
 *
 * Copyright (c) 2000	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Performance.h
 *
 *****************************************************************************/

// SOL++2000


#include <sol\Object.h>
#include <sol\LinkedList.h>

#ifndef _SOL_PERFORMANCE
#define _SOL_PERFORMANCE

typedef PERF_DATA_BLOCK				PerfDataBlock;
typedef PERF_OBJECT_TYPE			PerfObject;
typedef PERF_COUNTER_DEFINITION		PerfCounter;
typedef PERF_INSTANCE_DEFINITION	PerfInstance;
typedef PERF_COUNTER_BLOCK			PerfCounterBlock;


class Performance :public Object {

  private:
	DWORD	getIndex(const char* title);
	PerfDataBlock*  getDataBlock();

	PerfObject* getObjectType(PerfDataBlock* pdb){
		return (PerfObject*)((LPBYTE)pdb + pdb->HeaderLength);
	}

	PerfCounter*  firstCounter(PerfDataBlock* pdb) {
		PerfObject* pot = getObjectType(pdb);
		return (PerfCounter*)((LPBYTE)pot + pot->HeaderLength);
	}

	PerfCounter* nextCounter(PerfCounter* pcd) {
		return (PerfCounter*)((LPBYTE)pcd + pcd->ByteLength);
	}

	PerfInstance*  firstInstance(PerfDataBlock* pdb) {
		PerfObject*	pot = getObjectType(pdb);
		return (PerfInstance*)((PBYTE)pot + pot->DefinitionLength);
	}

	PerfInstance*  findNthInstance(PerfDataBlock* pdb, int index);

	PerfInstance*  nextInstance(PerfInstance* pid) {
		PerfCounterBlock*	pcb= (PerfCounterBlock*)((LPBYTE)pid + pid->ByteLength);
		return (PerfInstance*)((LPBYTE)pcb + pcb->ByteLength);
	}

	PerfCounterBlock*  firstCounterBlock(PerfDataBlock* pdb) {
		PerfInstance* pid = firstInstance(pdb);
		return (PerfCounterBlock*)((LPBYTE)pid + pid->ByteLength);
	}

	PerfCounterBlock*	 nextCounterBlock(PerfCounterBlock* pcb){
		PPERF_INSTANCE_DEFINITION	pid= (PerfInstance*)((LPBYTE)pcb + 
								pcb->ByteLength);
		return (PerfCounterBlock*)((LPBYTE)pid + pid->ByteLength);
	}

	DWORD	indexOffset(PerfDataBlock* pdb, const char* name);

	DWORD	getLongValue(PerfCounterBlock* pcb, DWORD offset) {
		return *((DWORD *)((PBYTE)pcb + offset));
	}

	void	getProcessName(PerfInstance* pid, char* name, 
				DWORD size) {
			WideCharToMultiByte(CP_ACP, WC_COMPOSITECHECK,
				(LPWSTR)((LPBYTE)pid + pid->NameOffset),
				-1, name, size, NULL, NULL);
	}

public:
	Performance() {}
	~Performance() {}

	void	getProcessList(LinkedList& list);
	BOOL	dumpTitleIndex();
};

#endif
