/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	MenuBar.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\MenuBar.h>
#include <sol\Item.h>


MenuBar::MenuBar(View* view, const char* name)
	:Menu(view)
{
	HWND   hwnd    = view -> getWindow();
	HINSTANCE progIns = (HINSTANCE)::GetWindowLong(hwnd, GWL_HINSTANCE);
	HMENU  hmenu   = ::LoadMenu(progIns, name);
	if(hmenu == NULL) {
		hmenu = ::CreateMenu();
	}
	set(hmenu);
	::SetMenu(hwnd, hmenu);
	::DrawMenuBar(hwnd);
}




void MenuBar::tearOff(int n)
{
	HMENU hpopup = ::GetSubMenu(get(), n);
	if(hpopup) {
		POINT p;
		::GetCursorPos(&p);
		View* owner = getOwner();
		int  h = ::GetSystemMetrics(SM_CYMENU);
		::TrackPopupMenu(hpopup, 0, p.x-h, p.y-h/2, 0,
			       owner->getWindow(), NULL);
	}
}



void MenuBar::append(const char* head, LinkedList* list)
{
	View* owner	= getOwner();
	HMENU hmenu	= get();
    HMENU hpopup= ::CreateMenu();

	::AppendMenu(hmenu, MF_STRING|MF_POPUP, (WORD)hpopup, head);

	if(list) {
		ListEntry* p = list -> getEntry();
		while(p) {
			Item* item = (Item *)(p->getObject());
			if(strcmp(item->getText(), "SEPARATOR") == 0) {
				::AppendMenu(hpopup, MF_SEPARATOR, 0, 0L);
			}
			else {
				::AppendMenu(hpopup, MF_STRING, 
					   item->getId(), item->getText());
			}
			p = p->getNext();
		}
	}
	::DrawMenuBar(owner ->getWindow());
}


void MenuBar::addPopupMenu(HMENU hpopup, LinkedList* list)
{
	if(list) {
		ListEntry* p = list -> getEntry();
		while(p) {
			Item* item = (Item *)(p->getObject());
			if(strcmp(item->getText(), "SEPARATOR") == 0) {
				::AppendMenu(hpopup, MF_SEPARATOR, 0, 0L);
			}
			else {
				::AppendMenu(hpopup, MF_STRING, 
					   item->getId(), item->getText());
			}
			p = p->getNext();
		}
	}
}


void MenuBar::changePopupMenu(int n, char* menuItems[])
{
	HMENU hmenu  = get();
	HMENU hpopup = ::GetSubMenu(hmenu, n);

	int count = ::GetMenuItemCount(hpopup);
	// For BC by Yamada of SOFT BANK.
	int i = 0;
	for(i = 0; i<count; i++) {
		::DeleteMenu(hpopup, 0, MF_BYPOSITION);
	}
	for(i = 0; menuItems[i] != NULL; i++) {
		if(strcmp(menuItems[i],"SEPARATOR") == 0) {
			::AppendMenu(hpopup, MF_SEPARATOR,0, 0L);
		}
		else {
			::AppendMenu(hpopup, MF_STRING,i, menuItems[i]);
		}
	}
}


HMENU MenuBar::getPopupHandle(int n)
{
	return ::GetSubMenu((HMENU)get(), n);
}


void MenuBar::update(int n, const char* head, LinkedList* items, HMENU hpopup) 
{
	HMENU hmenu = get();
	View* owner = getOwner();

	::ChangeMenu(hmenu,n, head, (WORD)hpopup, 
			MF_POPUP|MF_CHANGE|MF_BYPOSITION);
	int count = ::GetMenuItemCount(hpopup);
	for(int i = 0; i<count; i++) {
		::DeleteMenu(hpopup, 0, MF_BYPOSITION);
	}
	ListEntry* p = items -> getEntry();
	while(p) {
		Item* item = (Item *)(p->getObject());
		if(strcmp(item->getText(), "SEPARATOR") == 0) {
			::AppendMenu(hpopup, MF_SEPARATOR, 0, 0L);
		}
		else {
			::AppendMenu(hpopup, MF_STRING, item->getId(), 
					   (LPSTR)item->getText());
		}
		p = p -> getNext();
	}
	::DrawMenuBar(owner->getWindow());
}
