/******************************************************************************
 *
 * Copyright (c) 2000	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	MediaControlView.h
 *
 *****************************************************************************/

#include <sol\Application.h>
#include <sol\MediaControlView.h>


MediaControlView::MediaControlView(View* parent, const char* name, Args& args)
	   :Primitive(parent,  MCIWndCreate(parent->getWindow(),
			Application::getInstance(),
			//<modified date="2000.01.21">
			args.get(XmNstyle), 
			//</modified>
			name)) 
{
	// <added date="2000.01.09">
	setValues(args);
	// </added>
}


Boolean MediaControlView::create(View* parent, const char* name, Args& args)
{
	Boolean rc = False;
	View::setParent(parent);
	HWND hwnd = MCIWndCreate(parent->getWindow(),
			Application::getInstance(),
			args.get(XmNstyle), 
			name) ;
	if(hwnd) {
		Application::add(hwnd, this);
		setViewId((int)args.get(XmNid));

		View::setWindow(hwnd);

		rc = True;
	}

	setValues(args);
	return rc;
}
