/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	MdiFrame.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\MdiFrame.h>


static const long STYLE = (WS_OVERLAPPEDWINDOW|WS_CLIPCHILDREN);


MdiFrame::MdiFrame(Application& applet, const char* caption, Args& args)
	:Composite(NULL, caption, 
		args.set(XmNx,      (ulong)CW_USEDEFAULT)
		    .set(XmNy,      (ulong)CW_USEDEFAULT)
		    .set(XmNwidth,  (ulong)CW_USEDEFAULT)
		    .set(XmNheight, (ulong)CW_USEDEFAULT)
		    .set(XmNstyle,  (ulong)STYLE)
		    .set(XmNclassName, "MdiFrame")),

			application(applet),
			mdiClient(null),
			toolBar(null),
			statusBar(null),
			accel(null)
{

	applet.setToplevel(this);

	ulong val;

	const char* menuName = caption;
	if(args.get(XmNmenuName, &val)) {
		menuName = (char*)val;
	}
	menuBar   = new MenuBar(this, menuName);

	const char* accelName = caption;
	if (args.get(XmNacceleratorName, &val)) {
		accelName = (char*)val;
	}
	accel =  new Accelerator(accelName);

	int firstChildId = 1000;
	subMenuId = 0;

	if (args.get(XmNchildId, &val))	{
		firstChildId = (int)val;
	}
	if (args.get(XmNmenuId, &val)) {
		subMenuId = (int)val;
	}

	CLIENTCREATESTRUCT cs;
	cs.idFirstChild = firstChildId;
	cs.hWindowMenu  = ::GetSubMenu(menuBar->get(), subMenuId);

	DWORD style = WS_VSCROLL|WS_HSCROLL;
	style |= args.get(XmNmdiClientStyle);
	Args ar;
	ar.set(XmNparam, &cs);
	ar.set(XmNstyle, style);
	mdiClient   = new MdiClient(this, "mdi", ar);

}



MdiFrame::~MdiFrame()
{
	delete menuBar;
	delete accel;
	delete mdiClient;
}



long MdiFrame::size(Event& event)
{
	int toolBarHeight = 0;
	RECT r;
	if(toolBar) {
		toolBar -> send(event.getMessage(), 
			event.getWParam(), event.getLParam());
		toolBar -> getClientRect(&r);
		toolBarHeight = r.bottom - r.top;
	}
	int statusBarHeight = 0;
	if(statusBar) {
		statusBar -> send(event.getMessage(),
			event.getWParam(), event.getLParam());
		statusBar -> getClientRect(&r);
		statusBarHeight = r.bottom - r.top;
	}
	if(mdiClient) {
		getClientRect(&r);
		mdiClient -> reshape(0, toolBarHeight, 
			r.right, r.bottom - toolBarHeight - statusBarHeight);  		
	}
	return NULL;
}


long MdiFrame::command(Event& event)
{
	if(event.isMenuSelected() == TRUE ||
	   event.fromAccelerator() == TRUE) {
		int key = event.getMenuId();
		callCallback(XmNmenuCallback, key, NULL, event);
		return defaultProc(event);
	}
	else {
		HWND child = event.getChild();
		View* view = (View*)Application::lookup(child);
		const char* name = XmNactivateCallback;
		if(view) {
			name = view -> getCallbackName(event);
		}
		callCallback(name, (Key)child, NULL, event);
	}

	HWND child = mdiClient->getActiveWindow();

	if(::IsWindow(child)) {
		return ::SendMessage(child, WM_COMMAND,
			    event.getWParam(),
			    event.getLParam());
	}
	return defaultProc(event);
}


void MdiFrame::exit(Action& action)
{
	send(WM_CLOSE, 0, 0L);
}


long MdiFrame::defaultProc(Event& event)
{
	HWND hclient = NULL;
	if(mdiClient) hclient = mdiClient->getWindow();
	if(::IsWindow(hclient)) {
		return ::DefFrameProc(getWindow(), hclient,
				event.getMessage(), 
				event.getWParam(),
				event.getLParam());
	}
	else 
		return View::defaultProc(event);
}


void MdiFrame::realize()
{
	int cmdShow = application.getShowCommand();
	show(cmdShow);
}


BOOL MdiFrame::translate(MSG* msg)
{
	HACCEL haccel = accel->get();

	if(mdiClient &&  ::TranslateMDISysAccel(mdiClient->getWindow(), msg) ) {
		return TRUE;
	}

	if (haccel && ::TranslateAccelerator(getWindow(), haccel, msg)) {
		return TRUE;
	}
	else {
		return FALSE;
	}
}


void MdiFrame::setViewId(int vid)
{
	setId(vid);
}


void MdiFrame::childActivated(View* child)
{
	// Do nothing here.
}

