/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	LabelGadget.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\LabelGadget.h>
#include <sol\Brush.h>
#include <sol\ClientDC.h>


LabelGadget::LabelGadget(View* parent, const char* label, Args& args)
	:Gadget(parent, label, args) 
{
	status 		 = FALSE;
	backColor    = ::GetSysColor(COLOR_BTNFACE);
	textColor    = ::GetSysColor(COLOR_BTNTEXT);
	selTextColor = ::GetSysColor(COLOR_HIGHLIGHTTEXT);
	selBackColor = ::GetSysColor(COLOR_HIGHLIGHT);

	const char* ptr = (const char*)args.get(XmNlabelString);
	if(ptr == NULL) {
		ptr = label; 				  
	}
	if(ptr == NULL) {
		ptr = "";
	}
	text = new char[strlen(ptr)+1];
	strcpy(text, ptr);
	style = L_LEFT;

	ulong val;
	if (args.get(XmNstyle, &val)) {
		style = val;
	}
	
	if (args.get(XmNwidth) == 0 || args.get(XmNheight) == 0) {
		ClientDC dc(parent);
		SIZE size;
		dc.getTextExtent(text, strlen(text), &size);
		setSize(size.cx, size.cy);
	}
	font   = NULL;
	margin = 0;
}



LabelGadget::~LabelGadget()
{
	delete [] text;
}


Boolean LabelGadget::create(View* parent, const char* label, Args& args)
{
	Boolean rc = Gadget::create(parent, label, args); 

	status 		 = FALSE;
	backColor    = ::GetSysColor(COLOR_BTNFACE);
	textColor    = ::GetSysColor(COLOR_BTNTEXT);
	selTextColor = ::GetSysColor(COLOR_HIGHLIGHTTEXT);
	selBackColor = ::GetSysColor(COLOR_HIGHLIGHT);

	const char* ptr = (const char*)args.get(XmNlabelString);
	if(ptr == NULL) {
		ptr = label; 				  
	}
	if(ptr == NULL) {
		ptr = "";
	}
	text = new char[strlen(ptr)+1];
	strcpy(text, ptr);
	style = L_LEFT;

	ulong val;
	if (args.get(XmNstyle, &val)) {
		style = val;
	}
	
	if (args.get(XmNwidth) == 0 || args.get(XmNheight) == 0) {
		ClientDC dc(parent);
		SIZE size;
		dc.getTextExtent(text, strlen(text), &size);
		setSize(size.cx, size.cy);
	}
	font   = NULL;
	margin = 0;

	return rc;
}



void LabelGadget::draw(DC* dc)
{
	LabelGadget::draw(dc, 0, 0);
}

void LabelGadget::draw(DC* cdc, int x, int y)
{
	RECT r;
 	getRect(&r);
	r.left   += x;
	r.top    += y;
	r.right  += x;
	r.bottom += y;

	cdc->setBkMode(TRANSPARENT);

	COLORREF color = backColor;
	if(status) {
		color = selBackColor;
	}


	HGDIOBJ hfont = NULL;
	if(font) {
		hfont = cdc->select(font);
	}
	COLORREF tcolor = textColor;
	if(status) {
		tcolor = selTextColor;
	}
	cdc -> setTextColor(tcolor);
	cdc -> setBkColor(color);
	SIZE size;
	cdc -> getTextExtent(text, strlen(text), &size);

	// LABEL_LEFT 	
	int px = r.left + margin;
	int	py = r.top + ((r.bottom - r.top) - size.cy)/2;

	if(style == L_CENTER) {
		px = r.left + ((r.right - r.left) - size.cx)/2;
	}
	if(style == L_RIGHT) {
		px = r.right - size.cx - margin;
	}

	cdc -> extTextOut(px, py, ETO_CLIPPED|ETO_OPAQUE, &r, 
				text, strlen(text), NULL); 

	if(font) {
		cdc->select(hfont);
	}
}
