/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	FontDialog.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.01.09 Modifed getValues method.

#include <sol\Application.h>
#include <sol\FontDialog.h>


FontDialog::FontDialog(View* parent, const char* name, Args& args)
	:CommonDialog(parent, new CHOOSEFONT)
{
	CHOOSEFONT* cf = get();
	memset(cf, 0, sizeof(CHOOSEFONT));
	cf -> lStructSize = sizeof(CHOOSEFONT);
	cf -> lpLogFont = &lf;
	cf -> Flags     = CF_SCREENFONTS|CF_EFFECTS;
	cf -> nFontType = SCREEN_FONTTYPE;

	if(parent) {
		cf -> hwndOwner = parent -> getWindow();
	}

	cf -> hInstance = Application::getInstance();

	setValues(args);
}


Boolean FontDialog::create(View* parent, const char* name, Args& args)
{
	Boolean rc = CommonDialog::create(parent, new CHOOSEFONT);

	CHOOSEFONT* cf = get();
	memset(cf, 0, sizeof(CHOOSEFONT));
	cf -> lStructSize = sizeof(CHOOSEFONT);
	cf -> lpLogFont = &lf;
	cf -> Flags     = CF_SCREENFONTS|CF_EFFECTS;
	cf -> nFontType = SCREEN_FONTTYPE;

	if(parent) {
		cf -> hwndOwner = parent -> getWindow();
	}

	cf -> hInstance = Application::getInstance();

	setValues(args);

	return rc;
}



FontDialog::~FontDialog() 
{
	CHOOSEFONT* cf = get();
	if(cf -> lpfnHook) {
		FreeProcInstance((FARPROC)cf -> lpfnHook);
	}
	delete cf;
}


void FontDialog::getValues(Args& args)
{
	CHOOSEFONT* cf = get();
	ulong* val = NULL;
	int num   = args.getCount();
	Arg* arg  = args.getArgList();

	for (int i = 0; i<num; i++) {
		const char* name = arg[i].name;
		// <modified date="2000.01.09">
		val = (ulong*)arg[i].value;
		//</modified>

		if (name == XmNflags) {
			*val = (ulong)cf->Flags;
			continue;
		}
		if (name == XmNtype) {
			*val = (ulong)cf -> nFontType;
			continue;
		}
		if (name == XmNminimum) {
			*val = (ulong)cf -> nSizeMin;
			continue;
		}
		if (name == XmNmaximum) {
			*val = (ulong)cf -> nSizeMax;
			continue;
		}
		if (name == XmNlogicalFont) {
			*val = (ulong)cf -> lpLogFont;
			continue;
		}
	}
}


void FontDialog::setValues(Args& args)
{
	CHOOSEFONT* cf = get();
	ulong val;
	if (args.get(XmNdc, &val)) {
		cf -> Flags |= CF_PRINTERFONTS;
		cf -> nFontType |= PRINTER_FONTTYPE;
		cf -> hDC = (HDC)val;
	}
	if (args.get(XmNhook, &val)) {
		cf -> Flags |= CF_ENABLEHOOK;
		if(cf -> lpfnHook) {
			FreeProcInstance((FARPROC)cf -> lpfnHook);
		}
		cf -> lpfnHook = (HOOKFUN)MakeProcInstance((FARPROC)val,
					cf -> hInstance);
	}
	if (args.get(XmNflags, &val)) {
		cf ->Flags |= (DWORD)val;
	}
	if (args.get(XmNtype, &val)) {
		cf -> nFontType = (UINT)val;
	}
	if (args.get(XmNtemplateName, &val)) {
		cf -> Flags |= CF_ENABLETEMPLATE;
		cf -> lpTemplateName  = (char*)val;
	}
	if (args.get(XmNminimum, &val)) {
		cf -> nSizeMin = (int)val;
	}
	if (args.get(XmNmaximum, &val)) {
		cf -> nSizeMax = (int)val;
	}
}

int FontDialog::choose()
{
	setSelf();
	return ::ChooseFont(get());
}


// Modal popup
void FontDialog::popup(Action& action)
{
	int result = choose();
	
	action.setResult(result);
}
