/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	FindDialog.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.01.09 Modifed getValues method.

#include <sol\Application.h>
#include <sol\FindDialog.h>


FindDialog::FindDialog(View* parent, const char* name, Args& args)
	:CommonDialog(parent, new FINDREPLACE)
{
	findString    = new char[MAX_LEN];
	findString[0] = NULL;

	FINDREPLACE* fr = get();
	memset(fr, 0, sizeof(FINDREPLACE));
	fr -> lStructSize = sizeof(FINDREPLACE);

	if(parent) {
		fr -> hwndOwner = parent -> getWindow();
	}
	
	fr -> hInstance = Application::getInstance();

	fr -> lpstrFindWhat = findString;
	fr -> wFindWhatLen  = MAX_LEN;

	setValues(args);
}


FindDialog::~FindDialog() 
{
	FINDREPLACE* fr = get();
	if(fr -> lpfnHook) {
		FreeProcInstance((FARPROC)fr -> lpfnHook);
	}
	delete [] findString;
	delete fr;
}



Boolean FindDialog::create(View* parent, const char* name, Args& args)
{
	Boolean rc = CommonDialog::create(parent, new FINDREPLACE);

	findString    = new char[MAX_LEN];
	findString[0] = NULL;

	FINDREPLACE* fr = get();
	memset(fr, 0, sizeof(FINDREPLACE));
	fr -> lStructSize = sizeof(FINDREPLACE);

	if(parent) {
		fr -> hwndOwner = parent -> getWindow();
	}
	
	fr -> hInstance = Application::getInstance();

	fr -> lpstrFindWhat = findString;
	fr -> wFindWhatLen  = MAX_LEN;

	setValues(args);

	return rc;
}


void FindDialog::find()
{
	FINDREPLACE* fr = get();
	setWindow(::FindText(fr));
}


void FindDialog::find(char* string)
{
	FINDREPLACE* fr = get();
	if(strlen(string) >= MAX_LEN)
		*(string+ MAX_LEN-1) = NULL;

	strcpy(findString, string);
	setWindow(::FindText(fr));
}


void FindDialog::getValues(Args& args)
{
	FINDREPLACE* fr = get();
	ulong* val = NULL;
	int num   = args.getCount();
	Arg* arg  = args.getArgList();

	for (int i = 0; i<num; i++) {
		const char* name = arg[i].name;
		// <modified date="2000.01.09"> 
		val = (ulong*)arg[i].value;
		// </modifed>

		if (name == XmNflags) {
			*val = (ulong)fr->Flags;
			continue;
		}
		if (name == XmNfindString) {
			*val = (ulong)findString;
			continue;
		}
	}
}


void FindDialog::setValues(Args& args)
{
	FINDREPLACE* fr = get();
	ulong val;
	if (args.get(XmNflags, &val)) {
		fr -> Flags |= (DWORD)val;
	}
	if (args.get(XmNhook, &val)) {
		fr -> Flags |= FR_ENABLEHOOK;
		if (fr -> lpfnHook)
				FreeProcInstance((FARPROC)fr -> lpfnHook);
		fr -> lpfnHook = (HOOKFUN)MakeProcInstance((FARPROC)val,
					fr -> hInstance);
	}
	if (args.get(XmNfindString, &val)) {
		char* string = (char*)val;
		if(strlen(string) >= MAX_LEN) {
			*(string+MAX_LEN-1) = NULL;
		}
		strcpy(findString, string);
	}
}

