/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ExtendedComboBox.h
 *
 *****************************************************************************/

// SOL++2000
// 1999.09.23 Modified the super class from Primitive to ComboBox.
// 2000.02.18

#ifndef _SOL_COMBOBOX
#include <sol\ComboBox.h>
#endif

#ifndef _SOL_EXTENDEDCOMBOBOX
#define _SOL_EXTENDEDCOMBOBOX

class ExtendedComboBox :public ComboBox {
	static Arg  styles[];
  public:
	ExtendedComboBox():ComboBox() { }
  	ExtendedComboBox(View* parent, HWND hwnd)
		:ComboBox(parent, hwnd) { }

	ExtendedComboBox(View* parent, const char* name, Args& args);

	virtual Boolean create(View* parent, const char* name, Args& args);

	//
	int	deleteItem(int index) {
		return (int)send(CBEM_DELETEITEM, index, 0);
	}
	Arg*	getCallbackTable(int* num);

	HWND	getComboControl() {
			return (HWND)send(CBEM_GETCOMBOCONTROL, 0, 0);
	}

	HWND	getEditControl() {
			return (HWND)send(CBEM_GETEDITCONTROL, 0, 0);
	}
	DWORD	getExtendedStyle() {
			return (DWORD)send(CBEM_GETEXTENDEDSTYLE, 0, 0);
	}

	HIMAGELIST	getImageList() {
    		return (HIMAGELIST)send(CBEM_GETIMAGELIST, 0, 0L);
	}

	int		getItem(COMBOBOXEXITEM* item) {
			return (int)send(CBEM_GETITEM, 0, (LPARAM)item);
	}
	int		getUnicodeFormat() {
			return (int)send(CBEM_GETUNICODEFORMAT, 0, 0);
	}
	int		hasEditChanged() {
			return (int)send(CBEM_HASEDITCHANGED, 0, 0);
	}
	int		insertItem(COMBOBOXEXITEM* item) {
			return (int)send(CBEM_INSERTITEM, 0, (LPARAM)item);
	}

	DWORD	setExtendedStyle(DWORD mask, DWORD style) {
			return (DWORD)send(CBEM_SETEXTENDEDSTYLE, mask, style);
	}

	HIMAGELIST	setImageList(HIMAGELIST himl) {
    		return (HIMAGELIST)send(CBEM_SETIMAGELIST, 0, (LPARAM)himl);
	}
	int		setItem(COMBOBOXEXITEM* item) {
			return (int)send(CBEM_SETITEM, 0, (LPARAM)item);
	}
	int		setUnicodeFormat(BOOL flag) {
			return (int)send(CBEM_GETUNICODEFORMAT, (WPARAM)flag, 0);
	}
};

#endif
