/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ExtendedComboBox.cpp
 *
 *****************************************************************************/

// SOL++2000
// 1999.09.23 Modified the table of getCallbackTable
// to include the callback names of ComboBox.

#include <sol\ExtendedComboBox.h>


static const long STYLE = (const long)(WS_TABSTOP|WS_VSCROLL|CBS_NOINTEGRALHEIGHT);


// ExtendedComboBox can use the standard combobox style
Arg ExtendedComboBox::styles[] = {
	{XmNsortItems, 	     CBS_SORT},
	{XmNdisableNoScroll, CBS_DISABLENOSCROLL},
	{XmNoemConvert,      CBS_OEMCONVERT}
};


ExtendedComboBox::ExtendedComboBox(View* parent, const char* name, Args& args)
	:ComboBox(parent, name, 
			args.set(styles, XtNumber(styles))
			    .set(XmNpredefined, TRUE)
			    .set(XmNstyle, (ulong)STYLE)
			    .set(XmNclassName, (ulong)WC_COMBOBOXEX))

{
	setValues(args);
}



Boolean ExtendedComboBox::create(View* parent, const char* name, Args& args)
{
	Boolean rc = ComboBox::create(parent, name, 
			args.set(styles, XtNumber(styles))
			    .set(XmNpredefined, TRUE)
			    .set(XmNstyle, (ulong)STYLE)
			    .set(XmNclassName, (ulong)WC_COMBOBOXEX));


	setValues(args);

	return rc;
}


Arg* ExtendedComboBox::getCallbackTable(int* num)
{
	static Arg table[] = {
	{XmNcloseUpCallback,		CBN_CLOSEUP},
 	{XmNdefaultActionCallback,	CBN_DBLCLK},
 	{XmNdropDownCallback,		CBN_DROPDOWN},
	{XmNeditChangeCallback,		CBN_EDITCHANGE},
	{XmNeditUpdateCallback,		CBN_EDITUPDATE},
	{XmNerrorSpaceCallback,		(ulong)CBN_ERRSPACE},

	{XmNkillFocusCallback,		CBN_KILLFOCUS},
	{XmNselChangeCallback,		CBN_SELCHANGE},
	{XmNselEndCancelCallback,	CBN_SELENDCANCEL},
	{XmNselEndOkCallback,		CBN_SELENDOK},
	{XmNsetFocusCallback,		CBN_SETFOCUS},

	{XmNbeginEditCallback,		CBEN_BEGINEDIT},
 	{XmNdeleteItemCallback,		CBEN_DELETEITEM},
 	{XmNdragBeginCallback,		CBEN_DRAGBEGIN},
	{XmNendEditCallback,		CBEN_ENDEDIT},
	{XmNgetDispInfoCallback,	CBEN_GETDISPINFO},
	{XmNinsertItemCallback,		CBEN_INSERTITEM},
	};

	*num = XtNumber(table);
	return table;
}


