/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	DrawableTree.h
 *
 *****************************************************************************/

// SOL++2000

#ifndef _SOL_TREE
#include <sol\Tree.h>
#endif
#ifndef _SOL_DRAWABLENODE
#include <sol\DrawableNode.h>
#endif
#ifndef _SOL_FONT
#include <sol\Font.h>
#endif
#ifndef _SOL_PEN
#include <sol\Pen.h>
#endif

#ifndef _SOL_DRAWABLETREE
#define _SOL_DRAWABLETREE


class DrawableTree :public Tree {
	int 	arranged;
	int 	leftMargin;
	int 	topMargin;
	int 	horizSpacing;
	int		vertSpacing;
	int		arrangementPolicy;
	int		connectionPolicy;	
	int		width;
	int		height;

	DrawableNode* activeNode;	
	Font*	font;
	Pen*	pen;

  public:
	static int CONSTANT;
	static int VARIABLE;
	
  public:
	DrawableTree();
	~DrawableTree();

	void	draw(DC* dc, int x, int y);
	void	computeExtent(DC* dc, int* w, int* h);
	void	getExtent(int* w, int* h) { *w = width; *h = height; }

	int		getLeftMargin() { return leftMargin; }
	int		getHorizSpacing() { return horizSpacing; }
	int		getVertSpacing()  { return vertSpacing; }
	int		getTopMargin() { return topMargin; }
	int		load(const char* fileName);
	DrawableNode* search(DC* dc, int x, int y);
	void	setArrangementPolicy(int value) {
			arrangementPolicy = value;
	}
	void	setConnectionPolicy(int value) {
			connectionPolicy = value;
	}
	void	setBackground(COLORREF normal, COLORREF active);
	void	setTextColor(COLORREF normal, COLORREF active);
	void	setHorizSpacing(int value) { horizSpacing = value; }
	void	setVertSpacing(int value) { vertSpacing = value; }
	void	setLeftMargin(int margin) { leftMargin = margin; }
	void	setTopMargin(int margin) { topMargin = margin; }
	void	setActiveNode(DrawableNode* node, DC* dc, int x, int y);
	void	setFont(Font* afont) { font = afont;  }
	void	setPen(Pen* apen) {  pen = apen;  }
};

#endif

