/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	DrawableBinaryNode.h
 *
 *****************************************************************************/

// SOL++2000

#ifndef _SOL_BINARYNODE
#include <sol\BinaryNode.h>
#endif
#ifndef _SOL_DC
#include <sol\DC.h>
#endif

#ifndef _SOL_DRAWABLEBINARYNODE
#define _SOL_DRAWABLEBINARYNODE


class DrawableBinaryNode :public BinaryNode {
	int 		px;
	int 		py;
	BOOL		status;
	COLORREF	normalBackground;
	COLORREF	normalTextColor;
	COLORREF	activeBackground;
	COLORREF	activeTextColor;

	void		setDefaultColor();
  public:
	static int LINEAR;
	static int ZIGZAG;

  public:
	DrawableBinaryNode(DrawableBinaryNode* parent = null, 
			const char* name = null, Object* object = null);
	DrawableBinaryNode(DrawableBinaryNode* parent, const char*  name, 
			DrawableBinaryNode* left,
			DrawableBinaryNode* right);

	void		arrange(int width, int height, 
				int leftMargin, int topMargin);
	void		arrange(DC* dc, int xposition, int height, 
				int leftMargin, int topMargin);

	void		drawSelf(DC* dc, int x, int y, SIZE* size);
	void		draw(DC* dc, DrawableBinaryNode* root, 
				int policy, int x, int y);
	void		getExtent(DC* dc, int* maxx, int* maxy);
	BOOL		getStatus() { return status; }
	int   		nodeMaxLength(DC* dc, int len);
	DrawableBinaryNode*   search(char* name) {
			return (DrawableBinaryNode*)BinaryNode::search(name);
	}
	DrawableBinaryNode*   search(int id) {
			return (DrawableBinaryNode*)BinaryNode::search(id);
	}

	DrawableBinaryNode* 	search(DC* dc, int x, int y);
	void	setBackground(COLORREF normal, COLORREF active);
	void	setTextColor(COLORREF normal, COLORREF active);
						
	void	setStatus(BOOL flag) { status = flag; }
};

#endif
