/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	DoublyLinkedList.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\DoublyLinkedList.h>


DoublyLinkedList::DoublyLinkedList(Boolean gc1)
	:head(null), 
	 tail(null)
{
	gc    = gc1;
}


Boolean DoublyLinkedList::addFirst(Object* object)
{
	ListEntry* newEntry = new ListEntry(object, null, head);
	if (newEntry == null) {
		return False;
	}
	
	if (head != null) {
		head ->setPrev(newEntry);
	}

	// Set the head to be a newEntry. 
	head = newEntry;

	// If tail is null, set tail to be a newEntry
	if (tail == null) {
		tail = newEntry;
	}

	return True;
}


// Add an object to the tail of this list.
Boolean DoublyLinkedList::add(Object* object)
{
	ListEntry* newEntry= new ListEntry(object, tail, null);
	if (newEntry == null) {
		return False;
	}
	if (tail != null) {
		tail -> setNext(newEntry); 
	}

	// Set tail to be a newEntry. 

	tail = newEntry;

	// If head is null, set head to be a newEntry
	if (head == null) {
		head = newEntry;
	}
	return True;
}


Boolean DoublyLinkedList::remove(Object* object)
{
	Boolean rc = False;
	ListEntry* ptr  = head;
	ListEntry* prev = ptr;

	while (ptr) {
		Object* obj = ptr -> getObject();

		if (obj == object) {
			if (ptr != head && ptr != tail) {
					ListEntry* next = ptr -> getNext();
					prev -> setNext(next);
					if (next != null) {
						next -> setPrev(prev);
					}		
			}

			// If matched on the head of this list.

			if (ptr == head) {
				// Update the head.
				head = ptr -> getNext();
				head -> setPrev(null);
				ptr -> setPrev(null);
			}
				// If ptr were tail, update the tail. 
			if (ptr == tail) {
					tail = ptr -> getPrev();
					tail ->setNext(null);
			}

			if (gc == False) {
				ptr -> setObject(null);
			}

			// delete the ptr of ListEntry
			delete ptr;
			rc = True;
			break;

		} else {
			prev = ptr;
			ptr  = ptr -> getNext();
		}
	}
	return rc;
}


DoublyLinkedList::~DoublyLinkedList()
{
	clear();
}


Boolean DoublyLinkedList::isContained(Object* obj)
{
	Boolean rc = False;

	ListEntry* ptr  = head;

	while (ptr) {
		if (ptr -> getObject() == obj) {
			rc = True;
			break;
		}
		ptr = ptr -> getNext();
	}
	return rc;
}


void DoublyLinkedList::clear()
{
	ListEntry* ptr  = head;
	ListEntry* prev = ptr;

	while (ptr) {
		prev = ptr;
		ptr = ptr -> getNext();
		if (gc == False) {
			prev ->setObject(null);
		}
		delete prev;
	}
	head = null;
	tail = null;
}


int DoublyLinkedList::getLength() const
{
	ListEntry* ptr = head;
	int n = 0;
	while(ptr) {
		ptr = ptr -> getNext();
		n++;
	}
	return n;
}


Object* DoublyLinkedList::getNth(int n)
{
	int m = 0;

	Object* object = NULL;
	ListEntry* ptr = head;

	while(ptr) {
		if(m == n) {
			object = ptr ->getObject();
			break;
		}
		ptr = ptr -> getNext();
		m++;
	}
	return object;
}


// Simple selection sort
void DoublyLinkedList::sort(SortDirection dir)
{
	int length = getLength();
	int i = 0;
	ListEntry* ith = head;
   
    while (i<length-1) {	
		ListEntry* cth = ith;
		ListEntry* jth = ith -> getNext();
		Object*    obj = ith -> getObject();

		while (jth) {
			Object* jthObj = jth->getObject();
			if (dir == ASCENDING) {
				if (jthObj -> compare(obj) > 0) {
					cth = jth;
					obj = jth -> getObject();
				}	
			}
			if (dir == DESCENDING) {
				if (jthObj -> compare(obj) < 0) {
					cth = jth;
					obj = jth -> getObject();
				}	
			}
			jth = jth -> getNext();
		}

		cth -> setObject(ith->getObject());
		ith -> setObject(obj);

		ith = ith -> getNext();
		i++;
	}	// wile
}


void DoublyLinkedList::reverse()
{
	ListEntry* tmp = head;
	ListEntry* ptr = tail;
	ListEntry* rev = NULL;
        
	while (ptr) {
		ListEntry* prev = ptr -> getPrev();
		ListEntry* next = ptr -> getNext();
		ptr -> setNext(prev);
		ptr -> setPrev(next);
		ptr = prev;
	}

	head = tail;
	tail = tmp;
}
