/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Dimension.h
 *
 *****************************************************************************/

// SOL++2000
// 2000/11/18

#ifndef _SOL_OBJECT
#include <sol\Object.h>
#endif

#ifndef _SOL_DIMENSION
#define _SOL_DIMENSION

class Dimension :public Object {
	int	width;
	int height;

  public:
	Dimension(int w = 0, int h = 0)
		:width(w), height(h) { 
	
	}

	int	 getWidth() { return width; }

	int	 getHeight() { return height; }

	void get(int& w, int& h) {
		w = width;
		h = height;
	}
	// 2000/11/18 to-arai:Modified int -> void.
	void get(Dimension& d) {
		d.set(width, height);
	}

	void set(int w, int h) {
		width  = w;
		height = h;
	}


	void set(Dimension& d) {
		width  = d.getWidth();
		height = d.getHeight();
	}
};

#endif

