/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Composite.h
 *
 *****************************************************************************/

// SOL++2000
// 1999.10.09 Modified layout to be virtual.
// 1999.10.09 Added a getLayoutManager method.
// 2000.02.18
// 2001.03.11 Added a create method.

#ifndef _SOL_VIEW
#include <sol\View.h>
#endif
#ifndef _SOL_EXTENT
#include <sol\Extent.h>
#endif

#ifndef _SOL_LAYOUTMANAGER
#include <sol\LayoutManager.h>
#endif

#ifndef _SOL_PRIMITIVE
#include <sol\Primitive.h>
#endif

#ifndef _SOL_LAYOUTMANAGER
#include <sol\LayoutManager.h>
#endif

#ifndef _SOL_COMPOSITE
#define _SOL_COMPOSITE

class Composite :public View {
	static Arg styles[];
	HICON   hicon;
	HWND	hfocus;

	Extent	extent;
	int		pageIncrement;
	int		lineIncrement;
	Boolean	enableThumbTrack;
	LayoutManager* layoutManager;
	
	int  	moveThumb(Event& event, int type);

  public:
	static int	VERTICAL;
	static int	HORIZONTAL;

  protected:
	void 	doHorizScroll(Action& action);
	void 	doVertScroll(Action& action);
	const char*	findCallbackName(Event& event, HWND child);
	virtual long activate(Event& event);
	virtual long command(Event& event);
	virtual long horizScroll(Event& event);
	virtual long vertScroll(Event& event);
	virtual long notify(Event& event);
	virtual	long size(Event& event);

	const char*	isCommonNotification(Event& event);


  public:
	Composite():View() { }
	Composite(View* parent);

	Composite(View* parent, const char* name, Args& args);
	~Composite();

	virtual Boolean create(View* parent, const char* name, Args& args);

	// 2001/03/11 
	virtual Boolean create(View* parent);

	void	add(View* view) {
			layoutManager->add(view);
	}
	void	add(View* view, int pos) {
			layoutManager->add(view, pos);
	}

	void	add(View& view) {
			layoutManager->add(&view);
	}
	void	add(View& view, int pos) {
			layoutManager->add(&view, pos);
	}

	// 1999.10.09 Changed to be virtual
	virtual void layout(int x, int y, int w, int h);
	// 1999.10.09 Added
	LayoutManager* getLayoutManager() { return layoutManager; }

	void	getValues(Args& args);

	int		getScrollPos(int type) {
			return ::GetScrollPos(getWindow(), type);
	}
	void	getScrollRange(int type, int* min, int* max) {
			::GetScrollRange(getWindow(), type, min, max);
	}
	Boolean	enableScrollBar(UINT sbFlags, UINT arrows) {
			return ::EnableScrollBar(getWindow(), sbFlags,	arrows);
	}
	
	void	raise() {
			::BringWindowToTop(getWindow());
	}
	virtual void	realize();

	void	setLayout(LayoutManager* layout) {
			layoutManager = layout;
	}

	void 	setScrollPos(int type, int pos) {
			::SetScrollPos(getWindow(), type, pos, TRUE);
	}

	void	setScrollRange(int type, int min, int max) {
			::SetScrollRange(getWindow(), type, min, max, TRUE);
	}

	void	setValues(Args& args);

	virtual BOOL	translate(MSG*  msg) { 
		return FALSE;
	}

	int		dirList(const char* filename, int idList, int idStatic, 
		    	UINT fileType) {
			return ::DlgDirList(getWindow(), (char*)filename, idList, 
				idStatic, fileType);
	}
	int		dirListComboBox(const char* pathName, int idCombo, int idStatic, 
		    	UINT fileType) {
			return ::DlgDirListComboBox(getWindow(), (char*)pathName, 
				idCombo,  idStatic, fileType);
	}

	int		dirSelect(const char* pathName, int len, int idList) {
			return ::DlgDirSelectEx(getWindow(), (char*)pathName, len, idList);
	}

	int		dirSelectComboBox(const char* pathName, int len, int idCombo) {
			return ::DlgDirSelectComboBoxEx(getWindow(), (char*)pathName, 
				len, idCombo);
	}

	int		getItemText(int id, char* buffer, int max) {
		    return ::GetDlgItemText(getWindow(), id, buffer, max);
	}
	int		getItemInt(int id, BOOL* translated, BOOL sign) {
		    return ::GetDlgItemInt(getWindow(), id,
				translated, sign);
	}
	HWND	getItem(int id) {
		    return ::GetDlgItem(getWindow(), id);
	}
	HWND	getNextGroupItem(HWND control, BOOL prev) {
		    return ::GetNextDlgGroupItem(getWindow(), control, prev);
	}
	HWND	getNextTabItem(HWND control, BOOL prev) {
		    return ::GetNextDlgTabItem(getWindow(), control, prev);
	}

	void	checkButton(int id, UINT flag) {
		    ::CheckDlgButton(getWindow(), id, flag);
	}
	void	checkButton(int firstId, int lastId, int checkId) {
		    ::CheckRadioButton(getWindow(), firstId, lastId, checkId);
	}
	UINT	isButtonChecked(int id) {
		    return ::IsDlgButtonChecked(getWindow(), id);
	}
	LRESULT	sendDlgItem(int id, UINT message, WPARAM wParam, LPARAM lParam) {
			return ::SendDlgItemMessage(getWindow(), id, 
					message, wParam, lParam);
	}
	void	setItemText(int id, const char* string) {
		    ::SetDlgItemText(getWindow(), id, string);
	}
	void	setItemInt(int id, UINT val, BOOL sign) {
		    ::SetDlgItemInt(getWindow(), id, val, sign);
	}

	void	setScrollExtent(UINT w, UINT h);

	void	getScrollExtent(UINT* w, UINT* h) {
			extent.get(w, h);
	}
	void	justifyScrollRange();

	BOOL	getScrollInfo(int type, SCROLLINFO* scInfo);
	int		setScrollInfo(int type, SCROLLINFO* scInfo);

	void	getPreferredSize(Dimension& d);

	void	pack();
};

#endif
