/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ColorTable.h
 *
 *****************************************************************************/

// SOL++2000

#ifndef _SOL_HAHSHTABLE
#include <sol\HashTable.h>
#endif 

#ifndef _SOL_COLORITEM
#include <sol\ColorItem.h>
#endif

#ifndef _SOL_COLORTABLE
#define _SOL_COLORTABLE

class ColorTable :public HashTable {
	static ColorItem rgbTable[];
  public: static  long Black;
  public: static  long Blue;
  public: static  long Brown;
  public: static  long Cyan;
  public: static  long DarkBlue;
  public: static  long DarkCyan;
  public: static  long DarkGray;
  public: static  long DarkGreen;
  public: static  long DarkMagenta;
  public: static  long DarkRed;
  public: static  long Gray;
  public: static  long Green;
  public: static  long LightBlue;
  public: static  long LightCyan;
  public: static  long LightGray;
  public: static  long LightGreen;
  public: static  long LightMagenta;
  public: static  long LightRed;
  public: static  long Magenta;
  public: static  long Red;
  public: static  long White;
  public: static  long Yellow;

  public:
	ColorTable();
	BOOL get(const char* colorName, long* value);
};

#endif

