/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ColorTable.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\ColorTable.h>

long ColorTable::Black		=RGB(   0,    0,    0);
long ColorTable::Blue  		=RGB(   0,    0, 0xff);
long ColorTable::Brown		=RGB(0x80, 0x80,    0);
long ColorTable::Cyan		=RGB(   0, 0xff, 0xff);
long ColorTable::DarkBlue	=RGB(   0,    0, 0x80);
long ColorTable::DarkCyan	=RGB(   0, 0x80, 0x80);
long ColorTable::DarkGray	=RGB(0x80, 0x80, 0x80);
long ColorTable::DarkGreen 	=RGB(   0, 0x80,    0);
long ColorTable::DarkMagenta =RGB(0x80,    0, 0x80);
long ColorTable::DarkRed     =RGB(0x80,    0,    0);
long ColorTable::Gray		=RGB(0xc0, 0xc0, 0xc0);
long ColorTable::Green		=RGB(   0, 0xff,    0);
long ColorTable::LightBlue	=RGB(   0,    0, 0xff);
long ColorTable::LightCyan	=RGB(   0, 0xff, 0xff);
long ColorTable::LightGray	=RGB(0xc0, 0xc0, 0xc0);
long ColorTable::LightGreen	=RGB(   0, 0xff,    0);
long ColorTable::LightMagenta=RGB(0xff,    0, 0xff);
long ColorTable::LightRed	=RGB(0xff,    0,    0);
long ColorTable::Magenta	=RGB(0xff,    0, 0xff);
long ColorTable::Red		=RGB(0xff,    0,    0);
long ColorTable::White		=RGB(0xff, 0xff, 0xff);
long ColorTable::Yellow		=RGB(0xff, 0xff,    0);


ColorItem ColorTable::rgbTable[] = { 
	{"Black",	Black},
	{"Blue",	Blue},
	{"Brown",	Brown},
	{"Cyan",	Cyan},
	{"DarkBlue",	DarkBlue},
	{"DarkCyan",   	DarkCyan},
	{"DarkGray",  	DarkGray},
	{"DarkGreen", 	DarkGreen},
	{"DarkMagenta",	DarkMagenta},
	{"DarkRed",	DarkRed},
	{"Gray",	Gray},
	{"Green",	Green},
	{"LightBlue",	LightBlue},
	{"LightCyan",	LightCyan},
	{"LightGray",	LightGray},
	{"LightGreen",	LightGreen},
	{"LightMagenta", LightMagenta},
	{"LightRed",	LightRed},
	{"Magenta",	Magenta},
	{"Red",		Red},
	{"White",	White},
	{"Yellow",	Yellow},
	};


ColorTable::ColorTable()
	:HashTable(113)
{
	for(int i = 0; i<XtNumber(rgbTable); i++) {
		add(rgbTable[i].name, (Object*)&rgbTable[i]);
	}
}


BOOL ColorTable::get(const char* colorName, long* value)
{
	ColorItem* colorItem  = (ColorItem*) lookup(colorName);
	if(colorItem) {
		*value = colorItem->value;
		return TRUE;
	}
	else return FALSE;
}

