/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ColorDialog.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.01.09 Modified getValues method.
#include <sol\Application.h>
#include <sol\ColorDialog.h>


ColorDialog::ColorDialog(View* parent, const char* name, Args& args)
	:CommonDialog(parent, new CHOOSECOLOR)
{
	for(int i = 0; i<16; i++) {
		custColors[i] = RGB(255, 255, 255);
	}
	CHOOSECOLOR* cc = get();
	memset(cc, 0, sizeof(CHOOSECOLOR));
	cc -> lStructSize = sizeof(CHOOSECOLOR);
	cc -> Flags      = CC_FULLOPEN;
	cc -> rgbResult	 = RGB(255, 255, 255);
	cc -> lpCustColors = custColors;

	if(parent) {
		cc -> hwndOwner = parent -> getWindow();
	}	

	cc -> hInstance = (HWND)Application::getInstance();

	setValues(args);
}


ColorDialog::~ColorDialog() 
{
	CHOOSECOLOR* cc = get();
	if(cc -> lpfnHook) {
		FreeProcInstance((FARPROC)cc -> lpfnHook);
	}
	delete cc;
}


Boolean ColorDialog::create(View* parent, const char* name, Args& args)
{	
	Boolean rc = True;
	CommonDialog::create(parent, new CHOOSECOLOR);

	for(int i = 0; i<16; i++) {
		custColors[i] = RGB(255, 255, 255);
	}
	CHOOSECOLOR* cc = get();
	memset(cc, 0, sizeof(CHOOSECOLOR));
	cc -> lStructSize = sizeof(CHOOSECOLOR);
	cc -> Flags      = CC_FULLOPEN;
	cc -> rgbResult	 = RGB(255, 255, 255);
	cc -> lpCustColors = custColors;

	if(parent) {
		cc -> hwndOwner = parent -> getWindow();
	}	

	cc -> hInstance = (HWND)Application::getInstance();

	setValues(args);

	return rc;
}

void ColorDialog::getValues(Args& args)
{
	CHOOSECOLOR* cc = get();
	ulong* val = NULL;
	int num   = args.getCount();
	Arg* arg  = args.getArgList();

	for(int i = 0; i<num; i++) {
		const char* name = arg[i].name;
		// <modified date="2000.01.09">
		val = (ulong*)arg[i].value;
		// </modified>

		if(name == XmNflags) {
			*val = (ulong)cc->Flags;
			continue;
		}
		if(name == XmNrgbResult) {
			*val = (ulong)cc->rgbResult;
			continue;
		}
	}
}


void ColorDialog::setValues(Args& args)
{
	CHOOSECOLOR* cc = get();
	ulong val;
	if (args.get(XmNhook, &val)) {
		cc -> Flags |= CC_ENABLEHOOK;
		if (cc -> lpfnHook)
			FreeProcInstance((FARPROC)cc -> lpfnHook);
		cc -> lpfnHook = (HOOKFUN)MakeProcInstance((FARPROC)val,
// SOL++ 1.2 added casting. 95.08.23
					(HINSTANCE)cc -> hInstance);
	}
	if (args.get(XmNflags, &val)) {
		cc -> Flags |= (DWORD)val;
	}
	if (args.get(XmNtemplateName, &val)) {
		cc -> Flags |= CC_ENABLETEMPLATE;
		cc -> lpTemplateName  = (char*)val;
	}
}


int	ColorDialog::choose()
{
	setSelf();
	return ::ChooseColor(get());
}


void ColorDialog::popup(Action& action)
{
	int result = choose();
	action.setResult(result);
}

