
/*
dkc.h̃fBNgɂ邽
*/
#include "../dkc.h"
#include "sha1.h"
#include "sha2.h"

#define FOR if(FALSE){}else for

#define dODS(s) printf("%s\n",s)
#define if_free(s) if(s){free(s);s=NULL;}

extern void Test_dkcSJIS_StrSearch();

extern void Test_dkcPathString();

extern void Test_dkcStackAndQueue();

extern void Test_dkcString();

extern void Test_dkcCircularMemoryStream();

extern void Test_dkcSingleList();

extern void Test_dkcLZSS();

extern void Test_dkcSort();

extern void Test_dkcHashDigest();




///VtgSJISXLbvē̕
void Test_dkcSJIS_StrSearch(){
	const char *sjis="\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";
	size_t len,found;
	found = dkcSJIS_StrChrSearch(sjis,'\\');
	len = strlen(sjis);
	dkcmFORCE_NOT_ASSERT(found != len - 1);
}

///pXi[pRei
void Test_dkcPathString()
{

	const char *dir="Z:\\ok\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\xx.ok";
	const char *relative_dir="I:\\python\\..\\ruby\\..\\tcl\\..\\.\\\\\\.\\.\\.\\\\\\\\\\";
	const char *relative_dir2="\\python\\..\\ruby\\..\\tcl\\";
	{
		DKC_PATHSTRING *ps = dkcAllocPathString(dir);
		char buff[dkcdMAXPATH_BUFFER]="";

		//t@CpX̗vf̕\eXg
		dkcPathStringGetDrive(ps,buff,sizeof(buff));
		printf("Drive = %s ",buff);

		dkcPathStringGetFileName(ps,buff,sizeof(buff));
		printf("FileName = %s ",buff);

		dkcPathStringGetFileExtension(ps,buff,sizeof(buff));
		printf("FileExtension = %s ",buff);

		dODS("");
		//t@CpX̗vf̕eXg
		dkcPathStringDevideBegin(ps,buff,sizeof(buff));
		FOR(int i=0;;i++){
			int r;
			printf("%s ",buff);
			r = dkcPathStringDevideNext(ps,buff,sizeof(buff));
			if(edk_EndProcess==r){
				break;
			}
			dkcmNOT_ASSERT(DKUTIL_FAILED(r));
		}
		dkcPathStringDevideEnd(ps);
		dODS("");

		//pX̐K̃eXg
		dkcPathStringCopy(ps,relative_dir,strlen(relative_dir));
		
		printf("%s -> ",relative_dir);
		dODS(dkcPathStringPointer(ps));

		dkcPathStringCopy(ps,relative_dir2,strlen(relative_dir2));
		
		printf("%s -> ",relative_dir2);
		dODS(dkcPathStringPointer(ps));//ŁAAsĂt@ChCutĂB
		//printf("%s ",buff);

		dkcFreePathString(&ps);
		dODS("");
	}
}


///BBBB폜\
void Test_dkcSingleListObject(){
	{
		BYTE data = 'a';
		DKC_SINGLELIST_OBJECT *p = dkcAllocSingleListObject(&data,1);//push a
		data++;//b
		p->push_back(p,&data,1);//push b1
		p->push_back(p,&data,1);//push b2
		p->erase(p,p->begin(p)->mNext,p->begin(p)->mNext->mNext);//delete b1
		data++;//c
		p->push_back(p,&data,1);//push c;
		p->erase(p,p->begin(p),p->begin(p)->mNext);//delete b2

		FOR(DKC_SINGLELIST *it = p->begin(p);it != NULL;it = p->next(it))
		{
			BYTE buffer;
			p->getbuffer(it,&buffer,1);
			printf("%c ",buffer);//output:a c
		}
		dkcFreeSingleListObject(&p);
	}

}
///i[pReĩTv
void Test_dkcString(){
	const char *astr="abvb";
	const char *bstr="قق`I";
	const char *cstr="(߁)!!";
	{
		size_t alen = strlen(astr);
		size_t blen = strlen(bstr);
		size_t clen = strlen(cstr);
		DKC_STRING *p = dkcAllocString(alen);
		
		//dkcStringCopy(p,astr,alen);
		dkcStringConcatenate(p,astr,alen);
		dkcStringConcatenate(p,bstr,blen);
		dkcStringConcatenate(p,cstr,clen);

		dkcStringInsert(p,2,"ok",2);//abokvb
		dkcStringErase(p,0,2);//okvb
		dkcStringReplace(p,2,4,"OK",2);//okOK


		printf("DKC_STRING *p == %s",dkcStringPointer(p));
		printf("\n");

		dkcFreeString(&p);
	}
}
///~obt@iXg[j̃Tv
void Test_dkcCircularMemoryStream(){
	const int count = 5;
	const size_t bytes = (size_t)sizeof(int) * count;
	const char *astr="abcde";
	{
		DKC_CIRCULAR_MEMORYSTREAM *p = 
			dkcAllocCircularMemoryStream(bytes);

		//{mF
		FOR(int i=0;i<100;i++){
			if(DKUTIL_FAILED(dkcCircularMemoryStreamWrite(p,&i,sizeof(i)))){
				printf("count of %d | ",i);
				break;
			}
		}
		printf("DKC_CIRCULAR_MEMORYSTREAM(%d bytes): ",bytes);
		FOR(int i=0;i<count;i++){
			int r;size_t read;
			dkcCircularMemoryStreamRead(p,&r,sizeof(i),&read);
			dkcmNOT_ASSERT(sizeof(i) != read);
			printf("%d ",r);
		}
		dODS("");
		
		dkcCircularMemoryStreamClear(p);

		//ϒzꂽ̓mF
		FOR(int i=0;i<100;i++){//a ab abc abcd abcde
			if(DKUTIL_FAILED(dkcCircularMemoryStreamWrite(p,astr,i+1))){
				printf("count of %d | ", i );//i = 1Ȃ̂
				break;
			}
		}
		
		printf("DKC_CIRCULAR_MEMORYSTREAM(%d bytes): ",bytes);
		
		FOR(int i=0;i<100;i++){
			char r[bytes]="";
			size_t read;
			if(DKUTIL_FAILED(
				dkcCircularMemoryStreamRead(p,&r,count - i,&read)
				))
			{
				break;
			}
			dkcmNOT_ASSERT(size_t(count - i) != read);
			printf("%s ",(const char *)r);//aabab cabc dab cd e
		}
		dODS("");

		dkcFreeCircularMemoryStream(&p);
	}
		
}


///PXg̃Tv
void Test_dkcSingleList()
{
	{
		const char *begin_signature="begin--\n";
		DKC_SINGLELIST *p = dkcAllocSingleList(begin_signature,
			strlen(begin_signature) + 1);// + 1NULL

		if(!p) return;//G[I
		

		//{IȎg
		DKC_SINGLELIST *begin = p;

		{for(int i=0;i<5;i++){
			char st[2];
			st[0]='A';
			st[1]='\0';//NULL鎖ɂĕƂB
			dkcSingleListInsert(p,st,sizeof(st));
		}}
		
		{
			DKC_SINGLELIST *it = begin;
			printf("DKC_SINGLELIST : ");
			//for(int i=0;i<30;i++){
			for(;it != NULL;){
				printf((char *)it->mBuff);
				it = it->mNext;
			}
			dODS("");
		}

		//VACYeXg
		{
			DKC_SERIALIZE *pse1 = dkcAllocSerialize(
				edkcSerializeBufferMode,"slist_serialize01.bin");
			DKC_SERIALIZE *pse2 = dkcAllocSerialize(
				edkcSerializeFileMode,"slist_serialize02.bin");

			dkcSingleListSerialize(begin,pse1);
			dkcSingleListSerialize(begin,pse2);

			dkcFreeSerialize(&pse1);//Ńt@Cɕۑ
			dkcFreeSerialize(&pse2);//ƂfopenȂ̂fclose...

		}
		//fVACYeXg
		{
			//t@CɕۑVACYf[^J
			DKC_DESERIALIZE *pse = dkcAllocDeserialize(
				edkcSerializeBufferMode,"slist_serialize02.bin");

			//fVACYB
			DKC_SINGLELIST *sp = dkcAllocSingleListDeserialize(pse);
			//擪ۑĂȂƃ[NĂ܂B
			DKC_SINGLELIST *begin_tmp = sp;
			//̓VACYÕf[^
			DKC_SINGLELIST *tp = begin;

			//r...
			while(true){
				dkcmNOT_ASSERT(DKUTIL_FAILED(
					dkc_memcmp(sp->mBuff,sp->mSize,tp->mBuff,tp->mSize)
					));
				if(NULL==sp->mNext) break;
				sp = sp->mNext;
				tp = tp->mNext;
			}

			//fVACU
			dkcFreeDeserialize(&pse);
			//VOXg̈
			dkcFreeSingleList(&begin_tmp);
		}

		dkcFreeSingleList(&begin);
	}

}

///X^bNƃL[̃Tv
void Test_dkcStackAndQueue(){
	const size_t nums = 5;
	{
	
		DKC_STACK *p = dkcAllocStack(nums,sizeof(int));
		FOR(int i=0;i<100;i++){
			if(DKUTIL_FAILED(dkcStackPush(p,&i)))
				break;
		}
		printf("DKC_STACK(%d num): ",nums);
		FOR(int i=0;i<100;i++){
			int r;
			if(DKUTIL_FAILED(dkcStackTop(p,&r)))
				break;
			dkcStackPop(p);
			printf("%d ",r);
		}
		dODS("");
		dkcFreeStack(&p);
	}


	{
		DKC_QUEUE *p = dkcAllocQueue(nums,sizeof(int));
		FOR(int i=0;i<100;i++){
			if(DKUTIL_FAILED(dkcQueuePush(p,&i)))
				break;
		}
		FOR(int i=0;i<100;i++){
			int r;
			if(DKUTIL_FAILED(dkcQueueTop(p,&r)))
				break;
			dkcQueuePop(p);
		}
		FOR(int i=0;i<10;i++){
			dkcQueuePush(p,&i);
		}
		printf("DKC_QUEUE(%d num): ",nums);
		FOR(int i=0;i<10;i++){
			int r;
			if(DKUTIL_FAILED(dkcQueueTop(p,&r)))
				break;
			dkcQueuePop(p);
			printf("%d ",r);
		}
		dODS("");

		dkcQueueClear(p);

		//L[͐΂nums邩eXg
		FOR(int i=0;i<nums;i++){
			if(DKUTIL_FAILED(dkcQueuePush(p,&i)))
				break;
		}
		FOR(int i=0;i<nums - 3;i++){
			int r;
			if(DKUTIL_FAILED(dkcQueueTop(p,&r)))
				break;
			dkcQueuePop(p);
		}
		FOR(int i=0;i<nums;i++){
			if(DKUTIL_FAILED(dkcQueuePush(p,&i)))
				break;
		}
		printf("DKC_QUEUE(%d num): ",nums);
		FOR(int i=0;i<10;i++){
			int r;
			if(DKUTIL_FAILED(dkcQueueTop(p,&r)))
				break;
			dkcQueuePop(p);
			//23401
			printf("%d ",r);
		}
		dODS("");

		dkcFreeQueue(&p);
	}




}
///LZSSTv
void Test_dkcLZSS(){
	//LZSS̏
	DKC_LZSS *p = dkcAllocLZSS();//LZSSIuWFNgHւ̃|C^
	DKC_LZSS_HEADER header={0};//wb_[B
	const char *target="target.ico";
	BYTE *buffer;//obt@ւ̃|C^
	size_t readsize;//\ɓǂݍ񂾃TCY擾
	int result;//߂l

	size_t size = dkcFileSize(target);

	BYTE *dest;//k
	BYTE *check;//`FbNpobt@

	if(0==size){
		printf("%s݂Ȃ݂B",target);
		return;
		}
	
	buffer = (BYTE *)malloc(size);
	dest = (BYTE *)malloc(size);
	check = (BYTE *)malloc(size);
	
	if(NULL==buffer || NULL==dest || NULL==check){
		printf("%dbytemۂłȂ݂B",size);
		goto END;
		}
	if(DKUTIL_FAILED(dkcLoadBinary(buffer,size,target,&readsize))){
		printf("%sI[vłȂ݂B",target);
		goto END;
		}
	if(size != readsize){
		printf("Ȃ񂩃t@CTCYႤ݂EEEBʂ͂肦Ȃ񂾂ǂȂ");
		goto END;
		}
	
	printf("TestLZSSCompress()");
	printf("kO:%d byte ",size);
	//kÕf[^Rs[
	memcpy(check,buffer,size);

	//k
	result = dkcLZSSEncode(p,&header,(BYTE *)dest,size,(const BYTE *)buffer,size,size,dkcdLZSS_SIGNATURE);

	if(DKUTIL_FAILED(result)){
		if(edk_NoValueToProcess==result){
			printf("̃t@C͈k鉿l܂B");
		}else if(edk_BufferOverFlow==result){
			printf("obt@ӂ܂B");
		}else{
			printf("Ȃ񂩃G[łB");
		}
		goto END;
	}

	printf("k:%d byte ",header.mCompressedSize);
	//WJ
	dkcLZSSDecode(p,&header,(BYTE *)buffer,size,(const BYTE *)dest,size,dkcdLZSS_SIGNATURE);

	//`FbN
	dkcmNOT_ASSERT(DKUTIL_FAILED(
		dkc_memcmp(
		buffer,size,check,size
		)
	 )
	);

END:
	if_free(buffer);
	if_free(dest);
	if_free(check);
	dkcFreeLZSS(&p);

}



void print_mem(const char *name,const BYTE *p,size_t num){
	size_t i=0;
	printf("%s : ",name);
	for(;i<num;i++){
		printf("%02x",p[i]);
	}
	printf("\n");
}

void print_str(const char *name,const char *str){
	printf("%s = %s\n",name,str);
}


void Test_dkcHashDigest(){
	
	char str[1024 * 6]="";
	FILE *fp = fopen("target.ico","rb");
	fseek(fp,0,SEEK_END);
	long size = ftell(fp);
	fseek(fp,0,SEEK_SET);
	fread(str,1,size,fp);
	fclose(fp);


	//char buff[640]="";
	///菇
	{
		/*
		///܂Ä炤
		DKC_SHA1 *p = dkcAllocSHA1();
		///str̓eLoadB
		dkcSHA1Load(p,(const BYTE *)str,size);
		///FinalizeDigestbuffɔ[߂
		dkcSHA1FinalDigestStr(p,buff,sizeof(buff));
		///SHA1̃̈J
		dkcFreeSHA1(&p);
		///buff̒g\Ă݂B
		printf("sha1 = %s\n",buff);
		*/
		char bs[SHA384_STR_BUFFER_SIZE]="";
		{
			BYTE b1[SHA1_BIN_BUFFER_SIZE]="";

			DKC_SHA1 *p = dkcAllocSHA1();
			dkcSHA1Load(p,(const BYTE *)str,size);
			dkcSHA1FinalDigest(p,b1,sizeof(b1));
			dkcSHA1DigestStr(p,bs,sizeof(bs));
			dkcFreeSHA1(&p);
			print_mem("sha1",b1,sizeof(b1));
			print_str("sha1",bs);


			/*BYTE b2[SHA1_BIN_BUFFER_SIZE]="";
			sha1(b2,(const BYTE *)str,size);
			print_mem("sha1",b2,sizeof(b2));
			
			//SHA_VISUAL((DWORD *)b2);
			
			
			dkcmNOT_ASSERT(DKUTIL_FAILED(dkc_memcmp(b1,sizeof(b1),b2,sizeof(b2))));*/
		}
		{
			BYTE b1[SHA256_BIN_BUFFER_SIZE]="";

			DKC_SHA256 *p = dkcAllocSHA256();
			dkcSHA256Load(p,(const BYTE *)str,size);
			dkcSHA256FinalDigest(p,b1,sizeof(b1));
			dkcSHA256DigestStr(p,bs,sizeof(bs));
			dkcFreeSHA256(&p);
			print_mem("sha256",b1,sizeof(b1));
			print_str("sha256",bs);

			/*
			BYTE b2[SHA256_BIN_BUFFER_SIZE]="";
			sha256(b2,(const BYTE *)str,size);
			print_mem("sha256",b2,sizeof(b2));
			
			dkcmNOT_ASSERT(DKUTIL_FAILED(dkc_memcmp(b1,sizeof(b1),b2,sizeof(b2))));*/
		}
		{
			BYTE b1[SHA512_BIN_BUFFER_SIZE]="";

			DKC_SHA512 *p = dkcAllocSHA512();
			dkcSHA512Load(p,(const BYTE *)str,size);
			dkcSHA512FinalDigest(p,b1,sizeof(b1));
			dkcSHA512DigestStr(p,bs,sizeof(bs));
			dkcFreeSHA512(&p);
			print_mem("sha512",b1,sizeof(b1));
			print_str("sha512",bs);

			/*
			BYTE b2[SHA512_BIN_BUFFER_SIZE]="";
			sha512(b2,(const BYTE *)str,size);
			print_mem("sha512",b2,sizeof(b2));

			dkcmNOT_ASSERT(DKUTIL_FAILED(dkc_memcmp(b1,sizeof(b1),b2,sizeof(b2))));*/
		}
		{
			BYTE b1[SHA384_BIN_BUFFER_SIZE]="";


			DKC_SHA384 *p = dkcAllocSHA384();
			dkcSHA384Load(p,(const BYTE *)str,size);
			dkcSHA384FinalDigest(p,b1,sizeof(b1));
			
			print_mem("sha384",b1,sizeof(b1));
			dkcSHA384DigestStr(p,bs,sizeof(bs));
			print_str("sha384",bs);
			dkcFreeSHA384(&p);

			/*BYTE b2[SHA384_BIN_BUFFER_SIZE]="";
			sha384(b2,(const BYTE *)str,size);
			print_mem("sha384",b2,sizeof(b2));

			dkcmNOT_ASSERT(DKUTIL_FAILED(dkc_memcmp(b1,sizeof(b1),b2,sizeof(b2))));*/
		}



		


		//̑Hashn ( SHA256,MD5 ) łB
	}


}

#if 0
void Test_dkcRijndael(){
	const BYTE key[]="keykeykey";
	const BYTE data[RIJNDAEL_BLOCK_SIZE]={
		1,2,3,4,5,6,7,8,
		1,2,3,4,5,6,7,8,
		1,2,3,4,5,6,7,8,
		1,2,3,4,5,6,7,8,
	};
	BYTE dest[RIJNDAEL_BLOCK_SIZE],dest2[RIJNDAEL_BLOCK_SIZE];
	int i;

	size_t len = strlen((const char *)key);
	printf("original data:"); 
	for(i=0;i<RIJNDAEL_BLOCK_SIZE;i++){
		printf("%d,",data[i]);
	}
	printf("\n");

	{
		DKC_RIJNDAEL *p = dkcAllocRijndaelEncrypt(key,len);
	
		dkcRijndaelEncrypt(p,dest,sizeof(dest),data,sizeof(data));
	
		printf("rijndael encrypt:"); 
		for(i=0;i<RIJNDAEL_BLOCK_SIZE;i++){
			printf("%d,",dest[i]);
		}
		printf("\n");

		dkcFreeRijndael(&p);
	}

	{
		DKC_RIJNDAEL *p = dkcAllocRijndaelDecrypt(key,len);
	
		dkcRijndaelDecrypt(p,dest2,sizeof(dest2),dest,sizeof(dest));
	
		printf("rijndael decrypt:"); 
		for(i=0;i<RIJNDAEL_BLOCK_SIZE;i++){
			printf("%d,",dest2[i]);
		}
		printf("\n");

		dkcFreeRijndael(&p);
	}
	for(i=0;i<RIJNDAEL_BLOCK_SIZE;i++){
		dkcmNOT_ASSERT(data[i] != dest2[i]);
	}
	Sleep(4000);


}

#endif

//**********************************************************
//\[gnTv

int less_comp(const void *v1,const void *v2){
	/*int *i1,*i2;
	i1 = (int *)v1;
	i2 = (int *)v2;
	*/
	//return (*i1 < *i2);
	//return (*i1 < *i2) ? 1 : (*i1) < (*i2) ?  1 : 0;

	//return ((*i1) < (*i2));
	//return (*i1 - *i2) ? 1 : 0;
	return *( ( int * ) v1 ) - *( ( int * ) v2 );
}
int select_comp(const void *v1,const void *v2){
	int *i1,*i2;
	i1 = (int *)v1;
	i2 = (int *)v2;
	//return *( ( int * ) v1 ) - *( ( int * ) v2 );
	return ((*i1) < (*i2));
	//return *(i2) - *(i1);
}

void init_rand_array(int *arr,size_t num){
	dkcThreadLock_Lock();
	srand(1);
	for(size_t i=0;i<num;i++){
		arr[i] = rand();
	}
	dkcThreadLock_Unlock();
}

void print_rand(int *arr,size_t num){
	for(size_t i=0;i<num;i++){
		printf("%d,",arr[i]);
	}
	printf("\n");
}


void comb_sort(size_t num,int *base){
	
	int *b = base;
  int gap = num;
  if ( gap < 1 ) {

     return;
  }
  size_t first2 = num;
  BOOL swapped = FALSE;
  do {
    int newgap = (gap*10+3)/13;
    if ( newgap < 1 ) newgap = 1;
    //std::advance(first2, newgap-gap);
    first2 += newgap - gap;
		gap = newgap;
    swapped = FALSE;
    for ( size_t i = 0, j = first2;
          j != num;
          ++i, ++j) {
      if ( b[j] < b[i] ) {
        //std::iter_swap(i, j);
				SWAP_NUM(b[j],b[i]);
        swapped = TRUE;
      }
    }
  } while ( (gap > 1) || swapped );
}

#if 0

struct gdc{
	size_t count;
	void *data;
};

void calc_count(void *p , int min){

	//a[i];
}

static void *get_offset(void *p,size_t offset){
	BYTE *oo = (BYTE *)p;
	
	return (void *)&(oo[offset]);
}

void WINAPI dkcDistCountSortGeneric(size_t num, const void *a, void *b,
																		size_t buffsize,size_t width
																		int Min_,int Max_)
{

	int i, x;

	void *count = (int *)dkcAllocate(width * (Max_));

	//for (i = 0; i <= Max_ - Min_; i++) count[i] = 0;
	
	/*for (i = 0; i < num; i++){
		count[a[i] - Min_]++;
		}*/
	for(i = 0;i < num;i++){
		size_t byte_offset = calc_offset(a[i],Min_);
		BYTE *p = count;
		p[byte_offset];
		

	for (i = 1; i <= Max_ - Min_; i++){
		count[i] += count[i - 1];
		}
	for (i = num - 1; i >= 0; i--) {
		x = a[i] - Min_; b[--count[x]] = a[i]; //debuged
		//x = a[i] - Min_;  b[--count[x]] = x;//origin
	}
	dkcFree((void **)&count);

}

#endif

typedef int keytype;

keytype select(keytype a[], size_t n, int k,DKC_COMPARE_TYPE comp)
{
	int i, j, left, right;
	keytype x, t;

	left = 0;  right = n - 1;
	while (left < right) {
		x = a[k];  i = left;  j = right;
		for ( ; ; ) {
			//while (a[i] < x) i++;
			while(comp((const void *)&a[i] ,(const void *)&x)) i++;
			//while (x < a[j]) j--;
			while(comp((const void *)&x,(const void *)&a[j])) j--;
			if (i > j) break;
			t = a[i];  a[i] = a[j];  a[j] = t;
			i++;  j--;
		}
		if (j < k) left  = i;
		if (k < i) right = j;
	}
	return a[k];
}

keytype select_min(keytype a[],size_t n,DKC_COMPARE_TYPE comp){
	return select(a,n,0,comp);
}

keytype select_max(keytype a[],size_t n,DKC_COMPARE_TYPE comp){
	return select(a,n,n-1,comp);
}

void Test_dkcSort()
{
	int arr[10];
	int out[10];

	dkcThreadLockInit();


	init_rand_array(arr,10);
	qsort(arr,DKUTIL_ARRAY_NUMOF(arr),sizeof(arr[0]),less_comp);
	print_rand(arr,10);
	
	init_rand_array(arr,10);
	int min,max;
#	if 1
	int dmin,dmax;
	dmin = select_min(arr,10,select_comp);
	dmax = select_max(arr,10,select_comp);
	//dmin = min,dmax = max;
#endif
	//int pmax,pmin;
	dkcSelectMax(&max,arr,10,sizeof(int),select_comp);
	dkcSelectMin(&min,arr,10,sizeof(int),select_comp);

	//max = 
	//min = arr[os2];

	//distsort(10,arr,out,min,max);
	dkcDistCountSortInt(10,arr,out,min,max);
	print_rand(out,10);

	/*init_rand_array(arr,10);
	dkcShellSort(arr,DKUTIL_ARRAY_NUMOF(arr),sizeof(arr[0]),less_comp);
	print_rand(arr,10);

	init_rand_array(arr,10);
	dkcBubbleSort(arr,DKUTIL_ARRAY_NUMOF(arr),sizeof(arr[0]),less_comp);
	print_rand(arr,10);

	init_rand_array(arr,10);
	dkcCombSort(arr,DKUTIL_ARRAY_NUMOF(arr),sizeof(arr[0]),less_comp);
	print_rand(arr,10);
	*/
	dkcThreadLockEnd();
	Sleep(1000);
}

//**********************************************************


void Test_dkcRandom(){
	int i,t;
	ULONG seed = 10;
	for(i=0;i<USHRT_MAX * 10;i++){
		t = dkcRandom(&seed,UCHAR_MAX);
		dkcmNOT_ASSERT(t < 0 || t > UCHAR_MAX);
		/*if(t == UCHAR_MAX){
			dODS("*");
		}
		*/
	}
}

///rbg𕶎ɂărWAB
template<typename T>
inline bool BitIsVisualized( char *buff,size_t buffsize,T dt ,bool left=true)
{

	size_t len = sizeof(dt) * CHAR_BIT;;
	char *p=buff;
	if(len+1 > buffsize){//NULL
		return false;
	}
 // int a=0;
	if(left==false){
		for (size_t i=len-1; i >= 0; i-- ){
				// rbgԂ
				if(0 > _snprintf(p,buffsize,"%u",( dt>>i ) & 0x0001))
					return false;
				p++;
		}
	}else{
		for (size_t i=0; i < len; i++ ){
			// rbgԂ
			if(0 > _snprintf(p,buffsize,"%u",( dt>>i ) & 0x0001))
				return false;
			p++;
		}
	}
	return true;
}
void bit_printf(UINT bit){
	char buff[32 + 1]="";
	BitIsVisualized(buff,sizeof(buff),bit);
	printf("%s\n",buff);
}

void Test_dkcStream(){
	//DKC_STREAM *


}

void Test_dkcOpenFileWithSignature(){
	//S~f[^
	const char *dustbin="dust";
	//S~f[^̒
	size_t dustbin_size = strlen(dustbin);
	//t@C
	const char *filename = "fws.bin";
	//VOl`
	UINT signature = 'FWSS';
	//ރf[^
	const char *arr="dummydata dummydata";
	//ރTCY
	size_t write_size = strlen(arr);

	{
		DKC_FILE_WITH_SIGNATURE *p = dkcOpenFileWithSignature (
			edkcStreamLittleEndian,
			filename,"wb",
			dustbin,dustbin_size,
			signature
		);
	
		if(NULL==p){
			printf("ERROR\n ");
		}

		
		dkcFileWithSignatureWrite(p,arr,write_size);
		
		dkcCloseFileWithSignature(&p);
	}

	{
		char buff[512];
		size_t readsize = 0;

		DKC_FILE_WITH_SIGNATURE *p = dkcOpenFileWithSignature(
			edkcStreamLittleEndian,
			filename,"rb",
			dustbin,dustbin_size,
			signature
		);

		
		dkcFileWithSignatureRead(p,buff,sizeof(buff),
			&readsize);

		//ǂݍ񂾃TCY`FbN
		dkcmNOT_ASSERT(readsize != write_size);

		//`[gĂ邩ǂ`FbNB
		dkcmNOT_ASSERT(DKUTIL_FAILED(dkcFileWithSignatureCheckCheat(p)));

		dkcCloseFileWithSignature(&p);

	}



}



int main(int argc,char *argv[]){
	dkcCheckMemoryLeak(TRUE);
	
	//Test_dkcRijndael();

	//searchtest();
	//loadtest();
	//Test_dkcHashDigest();
	//return EXIT_SUCCESS;

	dODS("Test_dkcSort()");
	Test_dkcSort();
	dODS("");

	{

		UINT flag = 0;
		DKUTIL_FLAG_UP(flag,edkcStreamInitMemory);
		DKUTIL_FLAG_DOWN(flag,edkcStreamInitMemory);
		DKUTIL_FLAG_DOWN(flag,edkcStreamInitMemory);
		bit_printf(edkcStreamInitMemory);
		bit_printf(~edkcStreamInitMemory);
		
		bit_printf(flag);
		DKUTIL_FLAG_UP(flag,edkcStreamInitFile);
		//flag |= edkcStreamInitFile;
		//DKUTIL_FLAG_DOWN(flag,edkcStreamInitFile);
		//DKUTIL_FLAG_DOWN(flag,edkcStreamInitFile);
		bit_printf(flag);
	}

	dODS("Test_dkcOpenFileWithSignature()");
	Test_dkcOpenFileWithSignature();
	dODS("");

	dODS("Test_dkcRandom()");
	Test_dkcRandom();
	dODS("");


	dODS("Test_dkcSJIS_StrSearch()");
	Test_dkcSJIS_StrSearch();
	dODS("");

	dODS("Test_dkcPathString()");
	Test_dkcPathString();
	dODS("");

	dODS("Test_dkcStackAndQueue()");
	Test_dkcStackAndQueue();
	dODS("");

	dODS("Test_dkcString()");
	Test_dkcString();
	dODS("");

	dODS("Test_dkcCircularMemoryStream()");
	Test_dkcCircularMemoryStream();
	dODS("");

	dODS("Test_dkcSingleList()");
	Test_dkcSingleList();
	dODS("");

	dODS("Test_dkcLZSS()");
	Test_dkcLZSS();
	dODS("");

	dODS("Test_dkcHashDigest()");
	Test_dkcHashDigest();
	dODS("");

	system("PAUSE");
	return 0;
}
