/*!
@auther d
@note
licence:BSD Licence
*/

#include "dkcOSIndependent.h"
#include "dkcStream.h"
#include "dkcStdio.h"
#include <limits.h>


static DKC_INLINE int SetStreamInfo(DKC_STREAM *p,UINT flag){
	UINT stream_mode = 0;
	BYTE endian_mode = 0;
	UINT proc_mode = 0;

	BOOL isLittle = dkcIsLittleEndian();


	///Xg[̎ނ߂
	if(flag & edkcStreamInitMemory){
		stream_mode = edkcStreamInitMemory;
	}else if(flag & edkcStreamInitFile){
		stream_mode = edkcStreamInitFile;
	}else{
		goto Error;
	}


	endian_mode = FALSE;
	///GfBA߂
	if(flag & edkcStreamBigEndian){
		//endianmode = edkcStreamBigEndian;
		if(isLittle){
			endian_mode = TRUE;
		}
	}else if(flag & edkcStreamLittleEndian){
		//endianmode = edkcStreamLittleEndian;
		if(!isLittle){
			endian_mode = TRUE;
		}
	}else /*if(flag & edkcStreamInitDefaultEndian)*/{
		if(isLittle){
			//endianmode = edkcStreamLittleEndian;
		}else{
			//endianmode = edkcStreamBigEndian;
		}
	}

	//vZX̏ڍ ݒ
	proc_mode |= (flag & edkcStreamProcessDefault);
	if(0==proc_mode){
		proc_mode |= (flag & 	edkcStreamProcessAsOrdered);
		
		if(0==proc_mode){
			proc_mode |= 	edkcStreamProcessAsOrdered;
		}
	}
	proc_mode |= (flag & 	edkcStreamWriteErrorWhenEndianChange );

	//update
	p->mMode = stream_mode;

	dkcmNOT_ASSERT(proc_mode > UCHAR_MAX);
	p->mProcessMode = (BYTE)proc_mode;

	p->mChangeEndian = endian_mode;

	return edk_SUCCEEDED;
Error:
	return edk_FAILED;

}

DKC_STREAM *WINAPI dkcAllocStreamMemoryType(UINT flag,const void *default_data,size_t size){
	DKUTIL_FLAG_DOWN(flag,edkcStreamInitFile);
	DKUTIL_FLAG_UP(flag,edkcStreamInitMemory);
	return dkcAllocStream(flag,default_data,size,NULL,NULL);

}

DKC_STREAM *WINAPI dkcAllocStreamFileType(UINT flag,const char *filename,const char *mode){
	DKUTIL_FLAG_DOWN(flag,edkcStreamInitMemory);
	DKUTIL_FLAG_UP(flag,edkcStreamInitFile);
	return dkcAllocStream(flag,NULL,0,filename,mode);
}

DKC_STREAM * WINAPI dkcAllocStream(UINT flag,
																	 const void *default_data,size_t size,
																	 const char *filename,const char *mode)
{
	
	DKC_STREAM *p;
	void *psig;


	p = dkcAllocate(sizeof(DKC_STREAM));
	if(NULL==p){
		return NULL;
	}

	if(DKUTIL_FAILED(SetStreamInfo(p,flag))){
		goto Error;
	}

	switch(p->mMode){
	case edkcStreamInitMemory:
		psig = (void *)dkcAllocMemoryStream(size);
		if(NULL==psig){
			goto Error;
		}
		//update	
		p->mSig = psig;
		//write default data
		dkcStreamWrite(p,default_data,size);
		break;
	case edkcStreamInitFile:
		psig = (void *)dkcFOpen(filename,mode);
		if(NULL==psig){
			goto Error;
		}
		//update
		p->mSig = psig;
		
		break;
	default:
		goto Error;
	}

	
	//p->mEndianMode = endianmode

	return p;
Error:
	dkcFree(&p);
	return NULL;
}


int WINAPI dkcFreeStream(DKC_STREAM **p){
	DKC_STREAM *t;
	if(NULL==p){
		return edk_FAILED;
	}
	t = *p;
	if(NULL==t){
		return edk_FAILED;
	}

	switch(t->mMode){
	case edkcStreamInitMemory:
		dkcFreeMemoryStream((DKC_MEMORYSTREAM **)&(t->mSig));
		break;
	case edkcStreamInitFile:
		dkcFClose((FILE **)&(t->mSig));
		break;
#ifdef DEBUG
		default:
			dkcmNOT_ASSERT("dkcFreeStream FAILED");
#endif
	}
	return dkcFree(p);
}




int WINAPI dkcStreamSeek(DKC_STREAM *ptr,int offset,int origin){
	int r = edk_FAILED;
	switch(ptr->mMode){
	case edkcStreamInitMemory:
		r = dkcMemoryStreamSeek(ptr->mSig,offset,origin);
		break;
	case edkcStreamInitFile:
		r = fseek(ptr->mSig,offset,origin);
		break;
	}
	return r;

}

///stream̈ʒu擾B
long WINAPI dkcStreamTell(DKC_STREAM *ptr){
	int r = edk_FAILED;
	switch(ptr->mMode){
	case edkcStreamInitMemory:
		r =  dkcMemoryStreamTell(ptr->mSig);
	case edkcStreamInitFile:
		r = ftell(ptr->mSig);
	}
	return r;
	//dkcmNOT_ASSERT("dkcStreamTell failed");
}

static DKC_INLINE int dkcStreamReadObayAnOrder(
	DKC_STREAM *ptr,void *buffer,size_t size,size_t *readsize)
{
	int r = edk_FAILED;
	size_t readsize_ = 0;
	size_t count;
	size_t tc,tsize;
	BYTE *tbuffer;
	FILE *fp = ptr->mSig;

	if(NULL==readsize){
		readsize = &readsize_;
	}

	//1,sizëւƂǂH
	//1 = fread(buffer,size,1,ptr->mfp);
	//read size
	tsize = size;
	//temp variable
	tc = 0;
	//offset counter
	count = 0;
	//byte type pointer
	tbuffer = (BYTE *)buffer;
	for(;;)
	{
		//error check
		if(ferror(fp) ){
			//*readsize = count;
			r = edk_FAILED;
			break;
		}
		if(feof(fp)){
			//*readsize = count;
			r = edk_BufferOverFlow;
			break;
		}
		//read
		tc = fread(&tbuffer[count],1,tsize,fp);
		//update
		tsize -= tc;
		count += tc;

		if(count == size){
			r = edk_SUCCEEDED;
			break;
		}
#	ifdef DEBUG
		//肦ȂG[`FbN
		dkcmNOT_ASSERT(count > size);
#	else
		if(count > size){
			break;
		}
#	endif
	}
	*readsize = count;
	return r;

}

DKC_INLINE int WINAPI dkcStreamRead(DKC_STREAM *ptr,void *buffer,size_t size,size_t *readsize){
	int r = edk_FAILED;
	FILE *fp = ptr->mSig;
	size_t redsize = 0;
	if(NULL==readsize){
		readsize = &redsize;
	}

	//GfBA`FWw肳Ă``B
	/*if(flag & edkcStreamReadErrorWhenEndianChange){
		if(ptr->mChangeEndian){
			return edk_Not_Satisfactory;
		}
	}*/

	switch(ptr->mMode){
	case edkcStreamInitMemory:
		r = dkcMemoryStreamRead(ptr->mSig,
			buffer,size,readsize);
		break;
	case edkcStreamInitFile:

		if(ptr->mProcessMode & edkcStreamProcessDefault){
			*readsize = fread(buffer,1,size,fp);
			if(!ferror(fp)){
				r = edk_SUCCEEDED;
			}
		}else{
			r = dkcStreamReadObayAnOrder(ptr,buffer,size,readsize);
		}


		break;
	}
	return r;
}

static DKC_INLINE int dkcStreamWriteObayAnOrder(DKC_STREAM *ptr,const void *buffer,size_t size){
	int r = edk_FAILED;
	size_t tc,tsize;
	size_t count;
	const BYTE *tbuffer = buffer;
	FILE *fp;

	tc = 0;
	count = 0;
	tsize = size;
	fp =  ptr->mSig;

	for(;;){
		//error check
		if(ferror(fp)){
			return edk_FAILED;
		}
		if(feof(fp)){
			return edk_BufferOverFlow;
		}
		//write
		tc = fwrite(&tbuffer[count],1,tsize,fp);
		//update
		tsize -= tc;
		count += tc;

		if(count == size){
			r = edk_SUCCEEDED;
			break;
		}
#	ifdef DEBUG
		//肦ȂG[`FbN
		dkcmNOT_ASSERT(count > size);
#	else
		if(count > size){

			break;
		}
#	endif

	}


	return r;
}

DKC_INLINE int WINAPI dkcStreamWrite(DKC_STREAM *ptr,const void *buffer,size_t size)
{
	int r = edk_FAILED;

	UINT proc_flag = ptr->mProcessMode;
	///ݎw肪ȂĂ̂ťB
	if(proc_flag & edkcStreamWriteErrorWhenEndianChange){
		if(ptr->mChangeEndian){
			return edk_Not_Satisfactory;
		}
	}

	switch(ptr->mMode){
	case edkcStreamInitMemory:
		r =  dkcMemoryStreamWrite(ptr->mSig,buffer,size);
		break;
	case edkcStreamInitFile:
		r = dkcStreamWriteObayAnOrder(ptr,buffer,size);
		break;
	}

	return r;
}

static int WINAPI StreamWrite(DKC_STREAM *ptr, void *buffer,size_t size,void *hoge){
	return dkcStreamWrite(ptr,buffer,size);	
}

/*static DKC_INLINE dkcStreamWriteChangeEndian(DKC_STREAM *ptr,const void *buffer,size_t size){
	USHORT *pb;
	size_t elem_num;
	size_t i;

	pb = (USHORT)malloc(size);
	if(NULL==pb){
		return edk_FAILED;
	}

	memcpy(pb,buffer,size);
	elem_num = size / 16;

	//GfBA`FWB
	for(i=0;i<elem_num;i++){
		pb[i] = dkcReverseEndian16(pb[i]);
	}
	r = dkcStreamWrite(ptr,pb,size);

	free(pb);
}*/

int WINAPI dkcStreamWrite16(DKC_STREAM *ptr, const void *buffer,size_t size){
	return dkcStreamProcess16(ptr,(void *)buffer,size,StreamWrite,NULL);
}

int WINAPI dkcStreamWrite32(DKC_STREAM *ptr, const void *buffer,size_t size){
	return dkcStreamProcess32(ptr,(void *)buffer,size,StreamWrite,NULL);

}



int WINAPI dkcStreamWrite64(DKC_STREAM *ptr, const void *buffer,size_t size){
	return dkcStreamProcess64(ptr,(void *)buffer,size,StreamWrite,NULL);		
}




int WINAPI dkcStreamProcess(DKC_STREAM *ptr,void *buffer,size_t size,
														DKC_STREAM_PROCESS_TYPE write_t,void *data)
{
	return write_t(ptr,buffer,size,data);
}



int WINAPI dkcStreamProcess16(DKC_STREAM *ptr,void *buffer,size_t size,
																			 DKC_STREAM_PROCESS_TYPE write_t,void *data){
	int r;
	USHORT *pb;
	size_t elem_num,pause = 16;
	size_t i;

	if(size % pause != 0){
		return edk_ArgumentException;
	}
	if(ptr->mChangeEndian)
	{//GfBA`FWKv
		pb = (USHORT *)malloc(size);
		if(NULL==pb){
			return edk_FAILED;
		}
		
		//Rs[
		memcpy(pb,buffer,size);
		elem_num = size / pause;

		//GfBA`FWB
		for(i=0;i<elem_num;i++){
			pb[i] = dkcReverseEndian16(pb[i]);
		}
		//
		r = write_t(ptr,pb,size,data);

		free(pb);
	}else{
		r = write_t(ptr,buffer,size,data);
	}
	return r;
}
int WINAPI dkcStreamProcess32(DKC_STREAM *ptr,void *buffer,size_t size,
																			 DKC_STREAM_PROCESS_TYPE write_t,void *data){
	int r;
	ULONG *pb;
	size_t elem_num,pause = 32;
	size_t i;

	if(size % pause != 0){
		return edk_ArgumentException;
	}
	if(ptr->mChangeEndian)
	{//GfBA`FWKv
		pb = (ULONG *)malloc(size);
		if(NULL==pb){
			return edk_FAILED;
		}
		
		//Rs[
		memcpy(pb,buffer,size);
		elem_num = size / pause;

		//GfBA`FWB
		for(i=0;i<elem_num;i++){
			pb[i] = dkcReverseEndian32(pb[i]);
		}
		//
		r = write_t(ptr,pb,size,data);

		free(pb);
	}else{
		r = write_t(ptr,buffer,size,data);
	}
	return r;

}








int WINAPI dkcStreamProcess64(DKC_STREAM *ptr,void *buffer,size_t size,
																			 DKC_STREAM_PROCESS_TYPE write_t,void *data){
	int r;
	ULONGLONG *pb;
	size_t elem_num,pause = 64;
	size_t i;

	if(size % pause != 0){
		return edk_ArgumentException;
	}
	if(ptr->mChangeEndian)
	{//GfBA`FWKv
		pb = (ULONGLONG *)malloc(size);
		if(NULL==pb){
			return edk_FAILED;
		}
		
		//Rs[
		memcpy(pb,buffer,size);
		elem_num = size / pause;

		//GfBA`FWB
		for(i=0;i<elem_num;i++){
			pb[i] = dkcReverseEndian64(pb[i]);
		}
		//
		r = write_t(ptr,pb,size,data);

		free(pb);
	}else{
		r = write_t(ptr,buffer,size,data);
	}
	return r;
}



//streammemset(0)B(seekʒuŏɖ߂B
int WINAPI dkcStreamClear(DKC_STREAM *ptr){
	//file size
	size_t fsize;
	//temp size
	size_t tsize;
	size_t write_size;
	FILE *fp;
	int r = edk_FAILED;
	char null_array[1024];


	switch(ptr->mMode){
	case edkcStreamInitMemory:
		r = dkcMemoryStreamClear( ptr->mSig );
		break;
	case edkcStreamInitFile:
		
		memset(null_array,0,sizeof(null_array));
		fp = ptr->mSig;


		fseek( fp, 0, SEEK_END ) ;
		fsize = ftell( fp ) ;
		fseek( fp, 0, SEEK_SET ) ;
		
		if(fsize > sizeof(null_array))
		{//t@C̃TCYNULLz傫ꍇ
			
			tsize = 0;
			write_size = sizeof(null_array);
			for(;;){
				
				r = dkcStreamWrite(ptr,null_array,write_size);
				
				if(DKUTIL_FAILED(r)){
					return r;
				}
				if(tsize >= fsize){
					r = edk_SUCCEEDED;
					break;
				}

				if(tsize + write_size > fsize){
					write_size = fsize - tsize;
				}else{
					tsize += write_size;

					//͂Ȃǈꉞ
					write_size = sizeof(null_array);
				}
			}
		}else{//Ȃ㏑㏑
			r = dkcStreamWrite(ptr,null_array,fsize);
		}

		break;
	}
	return r;
}