/*!
@file dkcSafeFileSystem.h
@brief ₖh~@\t t@CVXe
@auther d
@note
<h4>E`N</h4?
http://studiokingyo.fc2web.com/dxlib/kowaza/k4.html#k19

<h4>Z[u</h4>
-t@Cɕۑ邷ׂẴf[^nbV֐ɐH킹B
-nbVlB
-t@Cɕۑ邷ׂẴf[^ÍB
-nbVlۑ
-Íf[^ۑ

<h4>[h</h4>
-t@CɕۑÍf[^Ƀ[h
-Ƀ[hf[^𕡍
-f[^nbV֐ɐH킹
-nbVlB
-t@CɕۑĂnbVlƂ擾nbVlׂB
iŃnbVlႤꍇ́AZ[uf[^₂ĂƔfłBj

<h4>t@C\</h4>
- wb_iꍇɂĂ͈ÍĂ肵ĂȂ襥j
	- [U[Ǝ̃VOl`
	- f[^̃TCY
	- nbVl
- f[^iꍇɂĂ͈ÍĂ肵ĂȂ襥)
	-f[^
*/
#ifndef dkutil_c_SafeFileSystem
#define dkutil_c_SafeFileSystem

#include "dkcCryptograph.h"
#include "dkcSHA1.h"
#include "dkcSJISFileSystem.h"
#include "dkcBuffer.h"
#include "dkcStream.h"

typedef struct dkc_FileHeader_FileWithSignature{
	///GfBAtO little endianTRUE
	BYTE little_endian;
	///̃t@Ĉ̃VOl`
	UINT sig;
	///t@C̃TCY
	ULONGLONG filesize;
	//f[^̃TCYŵ͉傫
	//ULONGLONG datasize;
	///nbVl̊i[
	BYTE hash_value[SHA1_BIN_BUFFER_SIZE]; 

}DKC_FILE_HEADER_FILE_WITH_SIGNATURE;

typedef struct dkc_FileWithSignature{
	DKC_STREAM *mStream;
	DKC_SHA1 *mSHA1;
	DKC_BUFFER *mDustbin;
	///݃[hȂTRUE
	BYTE mWriteMode;
	///ׂă[hȂTRUE
	BYTE mAllLoad;
	///t@Cwb_
	DKC_FILE_HEADER_FILE_WITH_SIGNATURE mFileHeader;
	
}DKC_FILE_WITH_SIGNATURE;


/*!
@param stream_flag[in] dkcAllocStream()Ɏgflag edkcStreamInitMemory͎g܂B
 //@param stream_size[in] dkcAllocStream()Ɏgsize
@param filename[in] t@C
@param mode[in] t@CI[v[h (aw肷ƃG[ƂďԂ܂Brww肵ĂBj
@param dustbin[in] S~f[^
@param dustbin_size[in] S~f[^̃TCY
@param signature[in] ʂt@C̃VOl`Bread open ŏ̃VOl`ႤƃG[ƂȂB
 //@param CheckCheat[out] [h OpenɃVOl``FbNȂNULLA
`FbNƂint^ϐւ̃|C^B
󂯎|C^悪edk_SUCCEEDED ȊO`[gĂB
- edk_FileSignatureException:t@C̓êωꂽB
- edk_FileCheated_Addition:t@C̓eɖ͖A璷ȃf[^tĂB

@return DKC_FILE_WITH_SIGNATUREւ̃|C^
*/
DKC_EXTERN DKC_FILE_WITH_SIGNATURE *WINAPI dkcOpenFileWithSignature(
	UINT stream_flag,//size_t stream_size,
	const char *filename,const char *mode,
	const void *dustbin,size_t dustbin_size,
	UINT signature
);


DKC_EXTERN int WINAPI dkcFileWithSignatureWrite(DKC_FILE_WITH_SIGNATURE *p,
																								const void *data,size_t size);

DKC_EXTERN int WINAPI dkcFileWithSignatureWrite16(DKC_FILE_WITH_SIGNATURE *p,
																								const void *data,size_t size);


DKC_EXTERN int WINAPI dkcFileWithSignatureWrite32(DKC_FILE_WITH_SIGNATURE *p,
																								const void *data,size_t size);

DKC_EXTERN int WINAPI dkcFileWithSignatureWrite64(DKC_FILE_WITH_SIGNATURE *p,
																								const void *data,size_t size);

/*!
@return ׂēǂݏI	edk_EndProcessԂ܂BȊO͎w肵tOɈˑ܂B
@note
GfBA̍l͂܂B
*/
DKC_EXTERN int WINAPI dkcFileWithSignatureRead(DKC_FILE_WITH_SIGNATURE *p,
																								void *data,size_t size,size_t *readsize);

/*!
@return edk_SUCCEEDEDȊO̓`[gĂBedk_LogicErrorȂĂяoԈĂB
ڂdkcOpenFileWithSignature()ɂāB
@note
dkcFileWithSignatureRead()edk_EndProcessԂĂ炱Ăяoă`[gĂ邩ǂm߂ĂB
*/
DKC_EXTERN int WINAPI dkcFileWithSignatureCheckCheat(DKC_FILE_WITH_SIGNATURE *p);

DKC_EXTERN int WINAPI dkcFileWithSignatureCheckCheatFile(const char *filename);

///SHA̍ŏI
///@note ʂɂĂяoȂĂdkcCloseFIleWithSignature()sĂ
DKC_EXTERN void WINAPI dkcFileWithSignatureFinal(DKC_FILE_WITH_SIGNATURE *p);
																												 

DKC_EXTERN int WINAPI dkcCloseFileWithSignature(DKC_FILE_WITH_SIGNATURE **);


//**********************************************************
//Í@\t t@CZ[u
//**********************************************************

typedef struct dkc_Arcfour_File{
	///nbVtt@CZ[uIuWFNg
	DKC_FILE_WITH_SIGNATURE *mFile;
	///ArcfourÍIuWFNg
	DKC_ARCFOUR_STATE *maf;
}DKC_ARCFOUR_FILE;

/*!
@see ̂قƂǂdkcOpenFileWithSignature()ƓB
@param arcfour_key[in] arcfourɎgL[
@param arcfour_size[in] arcfour_keỹTCY
@return DKC_ARCFOUR_FILE ւ̗̈ւ̃|C^
*/
DKC_EXTERN DKC_ARCFOUR_FILE *dkcOpenArcfourFile(
	UINT stream_flag,size_t stream_size,
	const char *filename,const char *mode,
	const void *dustbin,size_t dustbin_size,
	const void *arcfour_key,size_t arcfour_size,
	UINT signature,BOOL *IsCheated
);

DKC_EXTERN int dkcCloseArcfourFile(DKC_ARCFOUR_FILE **);


DKC_EXTERN int WINAPI dkcArcfourFileWrite(DKC_ARCFOUR_FILE *p,
																								const void *data,size_t size);

DKC_EXTERN int WINAPI dkcArcfourFileWrite16(DKC_ARCFOUR_FILE *p,
																								const void *data,size_t size);


DKC_EXTERN int WINAPI dkcArcfourFileWrite32(DKC_ARCFOUR_FILE *p,
																								const void *data,size_t size);

DKC_EXTERN int WINAPI dkcArcfourFileWrite64(DKC_ARCFOUR_FILE *p,
																								const void *data,size_t size);


DKC_EXTERN int WINAPI dkcArcfourFileRead(DKC_ARCFOUR_FILE *p,
																								void *data,size_t size);



#endif //end of include once