/*!
@file dkcSJISFileSystem.h
@auther d
@note
Licence is "BSD Licence"<br>
dkc_PathString̓pX𑊑΃pXłK΃pXɂĊi[܂B<br>
dkc_FileFinderSJISɑΉĂ܂B(OOGGj<br>
@brief ShiftJISlt@CVXe
*/
#ifndef dkutil_c_SJISFileSystem__h
#define dkutil_c_SJISFileSystem__h

#include "dkcOSIndependent.h"
#include "dkcMemoryStream.h"
#include "dkcString.h"
#include "dkcStack.h"

#ifdef WIN32

#else


# include "dirent.h"
# include "unistd.h"
# include "fcntl.h"
# include "utime.h"

#endif

DKC_EXTERN char * WINAPI dkcGetFileExtension( const char *PathName );

DKC_EXTERN int WINAPI dkcIsShiftJIS( const char *str, int nPos );

/* Generic */
/*! @return path݂āALȃpXTRUE */
DKC_EXTERN BOOL WINAPI dkcIsEffectivePath(const char *path,size_t size);

/*! @return pX΃pXTRUE */
DKC_EXTERN BOOL WINAPI dkcIsRelativityPath(const char *path);
/*! @return pX΃pXTRUE */
DKC_EXTERN BOOL WINAPI dkcIsAbsolutelyPath(const char *path);
/*!
@param dest[out] obt@ւ̃|C^
@param dsize[in] dest̃TCY
@param src[in] t@C̕
srcɓꂽJgfBNg+srcƂdestɏo͂B
@note
dsizedkcdMAXPATH_LENȉƎsB
@return edk_SUCCEEDEDŐ
*/
DKC_EXTERN int WINAPI dkcCurrentDirectoryConcatenate(char *dest,size_t dsize,const char *src);
/*!
@param dest[in] <b>JgfBNg̕񂪓Ă</b>obt@ւ̃|C^
@param dlen[in] dest̕
@param dsize[in] dest̃TCY
@param src[in] 
@return dlen + 2 > dsizeƃobt@I[o[t[\̂ŎsB
*/
DKC_EXTERN int WINAPI dkcDirectoryConcatenate(char *dest,size_t dlen,size_t dsize,const char *src);

///@return src̈Ԍɂ\\ĂTRUE
DKC_EXTERN BOOL WINAPI dkcIsTailPathSep(const char *src,size_t dlen);
/*!
@param dest[in] obt@
@param dlen[in] dest̕
@param size[in] dest̃TCY
@return 
edk_SUCCEEDEDȂ琬 <br>
edk_OutputBufferWasLost̓obt@Ȃ<br>
͓̑KvB<br>
*/
DKC_EXTERN BOOL WINAPI dkcPushBackPathSep(char *dest,size_t dlen,size_t size);

///pX𐳋K(΃pX΃pX)֐
DKC_EXTERN int WINAPI dkcToAbsolutelyPath(char *dest,size_t dsize,const char *src,size_t ssize);

/*!
//**********************************************************
t@CpX@[eBeB
//**********************************************************
*/
/*!
@note
dlF
mStringɃfBNgB
ŕK΃pXɕϊĂmStringɓB

*/
typedef struct dkc_PathString{
	DKC_STRING *mString;
	///Ce[gJEg
	size_t mIterateCount;
}DKC_PATHSTRING;

//PATHSTRING̊蓖āA
/*!
@param path[in] t@CAfBNgւ̃pXB
@return ȕ񂪎gĂA肭蓖ďoȂNULL
@note
pX΃pXꍇAŏɐ΃pXɕϊB
*/
DKC_EXTERN DKC_PATHSTRING * WINAPI dkcAllocPathString(const char *path);

DKC_EXTERN int WINAPI dkcFreePathString(DKC_PATHSTRING **);

//pX̃f[^𓾂B

DKC_EXTERN size_t WINAPI dkcPathStringSize(const DKC_PATHSTRING *);

DKC_EXTERN const char *WINAPI dkcPathStringPointer(const DKC_PATHSTRING *);


//pX؂B

DKC_EXTERN int WINAPI dkcPathStringDevideBegin(DKC_PATHSTRING *,char *buff,size_t size);
/*! @return  edk_EndProcessԂĂdkcPathStringDevideEnd()ĂяoďI */
DKC_EXTERN int WINAPI dkcPathStringDevideNext(DKC_PATHSTRING *,char *buff,size_t size);

DKC_EXTERN void WINAPI dkcPathStringDevideEnd(DKC_PATHSTRING *);




///pX𐳋KēB
DKC_EXTERN int WINAPI dkcPathStringCopy(DKC_PATHSTRING *,const char *buff,size_t size);
///pX𐳋KČqB
DKC_EXTERN int WINAPI dkcPathStringConcatenate(DKC_PATHSTRING *,const char *buff,size_t size);

/*
DKC_EXTERN int WINAPI dkcPathStringElementInsert(DKC_PATHSTRING *,const char *buff,size_t size);

DKC_EXTERN int WINAPI dkcPathStringElementReplace(DKC_PATHSTRING *,const char *buff,size_t size);
*/

DKC_EXTERN int WINAPI dkcPathStringGetDrive(DKC_PATHSTRING *,char *buff,size_t size);

DKC_EXTERN int WINAPI dkcPathStringGetFileExtension(DKC_PATHSTRING *,char *buff,size_t size);

DKC_EXTERN int WINAPI dkcPathStringGetFileName(DKC_PATHSTRING *,char *buff,size_t size);
/*!
@note
擾̍Ō\\tB
*/
DKC_EXTERN int WINAPI dkcPathStringGetDirectory(DKC_PATHSTRING *,char *buff,size_t size);


//**********************************************************
//֐̌LogicƂOĂ̂
//𗝉ĂȂꍇ͎gȕłB

///@see dkcPathStringDevideBegin()
DKC_EXTERN int WINAPI dkcPathStringDevideBegin_Logic(DKC_PATHSTRING *,size_t *count,char *buff,size_t size);
///@see dkcPathStringDevideNext()
DKC_EXTERN int WINAPI dkcPathStringDevideNext_Logic(DKC_PATHSTRING *,size_t *count,char *buff,size_t size);
///@see dkcPathStringDevideEnd()
DKC_EXTERN void WINAPI dkcPathStringDevideEnd_Logic(size_t *count);

///pX̗vf}B(K͂Ȃ len͕
DKC_EXTERN int WINAPI dkcPathStringElementInsert_Logic(DKC_PATHSTRING *,size_t count,
																								const char *src,size_t len);

DKC_EXTERN int WINAPI dkcPathStringElementErase_Logic(DKC_PATHSTRING *,size_t count);

///pX̗vfuB(K͂Ȃ len͕
DKC_EXTERN int WINAPI dkcPathStringElementReplace_Logic(DKC_PATHSTRING *,size_t count,
																								 const char *,size_t len);


/*!
//**********************************************************
t@C샆[eBeB
//**********************************************************
*/

/*! @return TRUEŐ */
DKC_EXTERN BOOL WINAPI dkcSetCurrentDirectory(const char *filename);

/*! @return TRUEŐ */
DKC_EXTERN BOOL WINAPI dkcGetCurrentDirectory(char *buff,size_t size);

/*!
@note
Thread safe ł͂܂B(safełȂĂvƎv܂B
*/
DKC_EXTERN int WINAPI dkcCreateDirectory(const char *pPath);
/*!
@note
thread safe ł͂܂BiCɂȂdkcFileCopyExgB)
̂ȂRs[t@CfJƏ~܂܂܂ɂȂĂ܂łB
*/
DKC_EXTERN BOOL WINAPI dkcFileCopy(const char *dest,const char *src);
/*!
@param inner_buffer_size[in] ̃Rs[Ŏgobt@̃TCYݒ肷B
@param bThreadLock[in] TRUEƃXbhbNB(傫t@C̏ꍇ͊댯)
@return TRUEƐ
@todo
HD̃TCY擾ăRs[̂Sǂ𒲂ׂȂ΂ȂȂB
XbhĂɏԂƂH
XbhbNIvV͔p~B
*/
DKC_EXTERN BOOL WINAPI dkcFileCopyEx(const char *dest,const char *src,
																		size_t inner_buffer_size,BOOL bThreadLock);
/*! t@C폜B @return 폜łTRUE @param filename[in] t@C*/
DKC_EXTERN BOOL WINAPI dkcFileRemove(const char *filename);
/*!
@param oldname[in] ÂOւ̃|C^
@param newname[in] VOւ̃|C^
*/
DKC_EXTERN BOOL WINAPI dkcFileRename(const char *oldname,const char *newname);

/*!
@return TRUEƃt@C݂
*/
DKC_EXTERN BOOL WINAPI dkcFileExist(const char *filename);
/*!
@return 0ƃt@CTCYO@܂́@G[ ܂@̓t@C݂Ȃ
*/
DKC_EXTERN UINT WINAPI dkcFileSize(const char *filename);
/*!
@param filename[in] t@C
@param rewrite[in] ㏑ۑ邩ǂH
zerobytẽt@C
*/
DKC_EXTERN BOOL WINAPI dkcCreateZeroByteFile(const char *filename,BOOL rewrite);

/*!
File邽߂̋@\̏Ԃۑ\
*/
typedef struct dkc_FileFinder{
	///Directory
	DKC_PATHSTRING *mDir;
	///target (wildcardOK)
	DKC_STRING *mTarget;
	///TufBNg邩HtO
	BOOL mbSubDir;
	///
	int mState;
	///X^bNB
	DKC_STACK *mStack;
#	ifdef WIN32
	///  
	HANDLE mHandle;
	WIN32_FIND_DATAA mFindData;
#	else //linux or unix...
	struct dirent *mDirent;
	DIR *mHandle;
#	endif
}DKC_FILE_FINDER;

typedef struct dkc_FindFile{
#	ifdef WIN32
	///  
	HANDLE mHandle;
	WIN32_FIND_DATAA mFindData;
#	else //linux or unix...
	struct dirent *mDirent;
	DIR *mHandle;
#endif
}DKC_FINDFILE;

DKC_EXTERN DKC_FINDFILE *WINAPI dkcAllocFindFile();

DKC_EXTERN int WINAPI dkcFreeFindFile(DKC_FINDFILE **);

/*! WindowsŌFindFirstFile()̃bp[ UNIXLINUXłH */
DKC_EXTERN int WINAPI dkcFindFirstFile(DKC_FINDFILE *ptr,const char *target);
/*! FindNextFile() @see dkcFindFirstFile() */
DKC_EXTERN int WINAPI dkcFindNextFile(DKC_FINDFILE *ptr);
/*! FindClose() @see dkcFindFirstFile() */
DKC_EXTERN int WINAPI dkcFindClose(DKC_FINDFILE *ptr);

DKC_EXTERN int WINAPI dkcFindFileGetFileName(DKC_FINDFILE *ptr,
																						 char *buff,size_t buffsize);

DKC_EXTERN BOOL WINAPI dkcFindFileIsFolder(DKC_FINDFILE *ptr);

DKC_EXTERN BOOL WINAPI dkcFindFileIsDot(DKC_FINDFILE *ptr);

DKC_EXTERN BOOL WINAPI dkcFindFileIsNormalFile(DKC_FINDFILE *ptr);

DKC_EXTERN BOOL WINAPI dkcFindFileIsReadOnly(DKC_FINDFILE *ptr);

DKC_EXTERN void WINAPI dkcFindFileSize(DKC_FINDFILE *ptr,ULONG *,ULONG *);




#if 0
enum edkcFileFinder{
	///sĂȂB
	edkcFileFinderEmpty = 0,
	///
	edkcFileFinderSearching,
	///IB
	edkcFileFinderFinish,
};


/*!
@param target[in] ^[Qbgt@CB(wild cardOKj
@param dir[in] fBNg(쓮̖悤ɃtpX]܂Bj
@param bSubDir[in] TRUEƃTufBNgB
@return NULLƈ̂ǂꂩOƂ낢 ƂsB
*/
DKC_EXTERN DKC_FILE_FINDER * WINAPI dkcAllocFileFinder(
			const char *target,const char *dir,BOOL bSubDir
			);

DKC_EXTERN int WINAPI dkcFreeFileFinder(DKC_FILE_FINDER **);


/*!
@param ptr[in] dkcAllocFileFinder()Ŏ擾|C^
@param path[in][out] pathdkcAllocPathString()Ŋmۂ̈gp鎖B
@param bCopySucceeded[out] pathփRs[TRUE𓾂B
@return edk_SUCCEEDEDȂdkcFileFinderNext() ܂AĂяoėǂB
ȊOȂdkcFreeFileFinder()ŏIȂ΂ȂȂB
*/
DKC_EXTERN int WINAPI dkcFileFinderNext(
	DKC_FILE_FINDER *ptr,DKC_PATHSTRING *path,BOOL *bCopySucceeded
);



/*! t@Cl[擾 
@return edk_LogicException̎͌ʂt@C̖Oł͂ȂB
Ȃ̂dkcFindNextFile()ĂяoKvB
*/
DKC_EXTERN int WINAPI dkcFileFinderReferenceFileName(DKC_FILE_FINDER *ptr,DKC_PATHSTRING *path);

#ifdef __cplusplus
namespace dkutil{


/*!
@param STL_T std::stringev[gɎpush_backgReiiFstd::list<std::string>
@param target[in] ^[Qbgt@CB(wild cardOKj
@param dir[in] fBNg(쓮̖悤ɃtpX]܂Bj
@param bSubDir[in] TRUEƃTufBNgB
@param c[in][out] STL_T^̃Rei
@return trueƐ
*/
template<class STL_T>
inline bool file_listup(const char *target,const char *dir,bool bSubDir,
												STL_T &c)
{
	//`
	//typedef STL_T::iterator iterator;
	
	bool result = false;
	BOOL bCopySucceeded = FALSE;
	DKC_PATHSTRING *pPath = NULL;
	DKC_FILE_FINDER *pFinder = NULL;

	//
	pPath = dkcAllocPathString(dir);
	if(NULL==pPath){	return false;}
	pFinder = dkcAllocFileFinder(target,dir,(BOOL)bSubDir);
	if(NULL==pFinder){ goto Error;}
	
	//std::string str;
	//
	for(;;){
		int r = dkcFileFinderNext(pFinder,pPath,&bCopySucceeded);
		if(edk_EndProcess == r){
			break;
		}else if(DKUTIL_FAILED(r)){
			goto Error;
		}
		if(TRUE==bCopySucceeded){//Rs[łĂB
			c.push_back(dkcPathStringPointer(pPath));
		}
	}
	
	result = true;

Error://G[n
	dkcFreePathString(&pPath);
	dkcFreeFileFinder(&pFinder);
	return result;
}


}
#endif //end of __cplusplus


#endif //end of if 0

#endif //end of include once