/*!
@file dkcSHA512.h
@brief SHA 512
@auther original : General Function Library  Copyright (C) 2000,2001 SYN All Rights Reserved.
        convert C by  d
*/
#ifndef dkutil_c_SHA512
#define dkutil_c_SHA512




#include "dkcOSIndependent.h"

#define SHA512_HASH   8
#define SHA512_BLOCK 16
#define SHA512_WORK  80


///SHA512̐nbVl(binary)ɕKvȃobt@TCY
#define SHA512_BIN_BUFFER_SIZE (SHA512_HASH * 8)
///SHA512̃nbVɕKvȃobt@TCY
#define SHA512_STR_BUFFER_SIZE (SHA512_HASH * 16 + 1)


typedef struct dkc_SHA512{
	BOOL  m_bMMX;
	///AꂪSHA512̃nbVl
	QWORD m_qwH[SHA512_HASH];
	QWORD m_qwLNumBits;
	QWORD m_qwHNumBits;
	QWORD m_aBlock[SHA512_BLOCK];
	int   m_nNumChr;
	BYTE mFinalized;
}DKC_SHA512;
/*
DKC_EXTERN DKC_SHA512 *WINAPI dkcAllocSHA512();

DKC_EXTERN void WINAPI dkcSHA512Init(DKC_SHA512 *);

DKC_EXTERN void WINAPI dkcSHA512Load(DKC_SHA512 *p,const BYTE *byte,DWORD size);

DKC_EXTERN void WINAPI dkcSHA512Final(DKC_SHA512 *p);

DKC_EXTERN int WINAPI dkcSHA512Digest(DKC_SHA512 *p,char *buff,size_t size);

DKC_EXTERN int WINAPI dkcFreeSHA512(DKC_SHA512 **);
*/



/*!
@return DKC_SHA512\̂ւ̊mۂ̈
@note
łdkcSHA512Init()͌Ă΂Ă܂B
*/
DKC_EXTERN DKC_SHA512 *WINAPI dkcAllocSHA512();
///@return dkcAllocSHA512()擾̈B
DKC_EXTERN void WINAPI dkcSHA512Init(DKC_SHA512 *);
/*!
@param p[in][out] dkcAllocSHA512()Ŏ擾|C^
@param pBuffer[in] ǂݎobt@ւ̃|C^
@param dwSize[in] obt@ɃANZXOKȃTCY
*/
DKC_EXTERN void WINAPI dkcSHA512Load(DKC_SHA512 *p,const BYTE *pBuffer,DWORD dwSize);


/*!
@param p[in][out] dkcAllocSHA512()Ŏ擾|C^
@note
dkcSHA512FinalDigest()gp鎖サ܂B
*/
DKC_EXTERN void WINAPI dkcSHA512Final(DKC_SHA512 *p);
/*!
@param p[in][out] dkcAllocSHA512()Ŏ擾|C^
@param buff[out] ރobt@ւ̃|C^
@param size[in] buff̃TCY
@return edk_SUCCEEDEDԂ
*/
///Message Digest擾B
DKC_EXTERN int WINAPI dkcSHA512DigestStr(DKC_SHA512 *p,char *buff,size_t size);

///oCiMessage Digest擾B
DKC_EXTERN int WINAPI dkcSHA512Digest(DKC_SHA512 *p,BYTE *buff,size_t size);

/*!
@see A߂lɂĂdkcSHA512DigestStr()ƓłB 
@note
dkcSHA512Final()dkcSHA512DigestStr()gpÅ֐̎gpサ܂B
*/
DKC_EXTERN int WINAPI dkcSHA512FinalDigestStr(DKC_SHA512 *p,char *buff,size_t size);
///@see dkcSHA512Digest() dkcSHA512FinalDigestStr()
///dkcSHA512FinalDigestStr() binarỹnbVl 
DKC_EXTERN int WINAPI dkcSHA512FinalDigest(DKC_SHA512 *p,BYTE *buff,size_t size);

/*!
@param p[in][out] dkcAllocSHA512()Ŏ擾|C^ւ̃|C^
@return 肭Jłedk_SUCCEEDED
*/
DKC_EXTERN int WINAPI dkcFreeSHA512(DKC_SHA512 **p);
#endif //end of include once