/*!
@file dkcSHA256.h
@brief SHA 256 
@auther original : General Function Library  Copyright (C) 2000,2001 SYN All Rights Reserved.
        convert C by  d
*/
#ifndef dkutil_c_SHA256
#define dkutil_c_SHA256

#include "dkcOSIndependent.h"

#define SHA256_HASH   8
#define SHA256_BLOCK 16
#define SHA256_WORK  64


///SHA256̐nbVl(binary)ɕKvȃobt@TCY
#define SHA256_BIN_BUFFER_SIZE (SHA256_HASH * 4)
///SHA256̃nbVlɕKvȃobt@TCY
#define SHA256_STR_BUFFER_SIZE (SHA256_HASH * 8 + 1)

typedef struct dkc_SHA256{
	DWORD m_dwH[SHA256_HASH];
	DWORD m_dwLNumBits;
	DWORD m_dwHNumBits;
	DWORD m_aBlock[SHA256_BLOCK];
	int   m_nNumChr;
	BYTE mFinalized;
}DKC_SHA256;
/*
DKC_EXTERN DKC_SHA256 *WINAPI dkcAllocSHA256();

DKC_EXTERN void WINAPI dkcSHA256Init(DKC_SHA256 *);

DKC_EXTERN void WINAPI dkcSHA256Load(DKC_SHA256 *p,const BYTE *pBuffer,DWORD dwSize);

DKC_EXTERN void WINAPI dkcSHA256Final(DKC_SHA256 *p);

DKC_EXTERN int WINAPI dkcSHA256Digest(DKC_SHA256 *p,char *buff,size_t size);

DKC_EXTERN int WINAPI dkcFreeSHA256(DKC_SHA256 **);
*/



/*!
@return DKC_SHA256\̂ւ̊mۂ̈
@note
łdkcSHA256Init()͌Ă΂Ă܂B
*/
DKC_EXTERN DKC_SHA256 *WINAPI dkcAllocSHA256();
///@return dkcAllocSHA256()擾̈B
DKC_EXTERN void WINAPI dkcSHA256Init(DKC_SHA256 *);
/*!
@param p[in][out] dkcAllocSHA256()Ŏ擾|C^
@param pBuffer[in] ǂݎobt@ւ̃|C^
@param dwSize[in] obt@ɃANZXOKȃTCY
*/
DKC_EXTERN void WINAPI dkcSHA256Load(DKC_SHA256 *p,const BYTE *pBuffer,DWORD dwSize);


/*!
@param p[in][out] dkcAllocSHA256()Ŏ擾|C^
@note
dkcSHA256FinalDigest()gp鎖サ܂B
*/
DKC_EXTERN void WINAPI dkcSHA256Final(DKC_SHA256 *p);
/*!
@param p[in][out] dkcAllocSHA256()Ŏ擾|C^
@param buff[out] ރobt@ւ̃|C^
@param size[in] buff̃TCY
@return edk_SUCCEEDEDԂ
*/
///
DKC_EXTERN int WINAPI dkcSHA256DigestStr(DKC_SHA256 *p,char *buff,size_t size);

///oCi @see dkcSHA256DigestStr
DKC_EXTERN int WINAPI dkcSHA256Digest(DKC_SHA256 *p,BYTE *buff,size_t size);

/*!
@see A߂lɂĂdkcSHA256DigestStr()ƓłB 
@note
dkcSHA256Final()dkcSHA256DigestStr()gpÅ֐̎gpサ܂B
*/
DKC_EXTERN int WINAPI dkcSHA256FinalDigestStr(DKC_SHA256 *p,char *buff,size_t size);

///oCi @see dkcSHA256DigestStr();
DKC_EXTERN int WINAPI dkcSHA256FinalDigest(DKC_SHA256 *p,BYTE *buff,size_t size);

/*!
@param p[in][out] dkcAllocSHA256()Ŏ擾|C^ւ̃|C^
@return 肭Jłedk_SUCCEEDED
*/
DKC_EXTERN int WINAPI dkcFreeSHA256(DKC_SHA256 **p);

#endif //end of include once