
/*!
@file dkcRijndael.c
@brief Rijndael Algorithm Wrapper
@note


*/


#include "dkcRijndael.h"
#include "dkcStdio.h"
#if 0

#include "rijndael/aes.h"



DKC_RIJNDAEL *WINAPI dkcAllocRijndaelEncrypt(const BYTE *key,size_t keysize){
	DKC_RIJNDAEL *p = dkcAllocate(sizeof(DKC_RIJNDAEL));
	if(NULL==p){
		return NULL;
	}
	//p->mKey = dkcAllocMemoryStream(keysize);

	if(aes_good != aes_enc_key(key,keysize,&(p->mCtx))){
		dkcFreeRijndael(&p);
		return NULL;
	}
	return p;
}


DKC_RIJNDAEL *WINAPI dkcAllocRijndaelDecrypt(const BYTE *key,size_t keysize){
	DKC_RIJNDAEL *p = dkcAllocate(sizeof(DKC_RIJNDAEL));
	if(NULL==p){
		return NULL;
	}

	if(aes_good != aes_dec_key(key,keysize,&(p->mCtx))){
		dkcFreeRijndael(&p);
		return NULL;
	}
	return p;

}

int WINAPI dkcRijndaelEncrypt(DKC_RIJNDAEL *p,BYTE *dest,size_t dsize,const BYTE *src,size_t ssize){
	size_t i;
	if(ssize % BLOCK_SIZE != 0){
		//BLOCK_SIZEŊ鐔łȂƂ˂B
		return edk_LogicError;
	}
	for( i=0;i<ssize;i += BLOCK_SIZE)
	{
#	ifdef NDEBUG
		if(aes_bad==aes_enc_blk(&src[i],&dest[i],&(p->mCtx))){
			return edk_FAILED;
		}
#	else
		dkcmNOT_ASSERT(aes_bad==aes_enc_blk(&src[i],&dest[i],&(p->mCtx)));
#	endif
	}
	return edk_SUCCEEDED;
}

int WINAPI dkcRijndaelDecrypt(DKC_RIJNDAEL *p,BYTE *dest,size_t dsize,const BYTE *src,size_t ssize){
	size_t i;
	
	if(ssize % BLOCK_SIZE != 0){
		//BLOCK_SIZEŊ鐔łȂƂ˂B
		return edk_LogicError;
	}

	for( i=0;i<ssize;i += BLOCK_SIZE)
	{
#	ifdef NDEBUG
		if(aes_bad==aes_dec_blk(&src[i],&dest[i],&(p->mCtx))){
			return edk_FAILED;
		}
#	else
		dkcmNOT_ASSERT(aes_bad==aes_dec_blk(&src[i],&dest[i],&(p->mCtx)));
#	endif
	}
	return edk_SUCCEEDED;
}

int WINAPI dkcFreeRijndael(DKC_RIJNDAEL **p){
	if(NULL==p){
		return edk_FAILED;
	}
	return dkcFree(p);
}

#endif