
/*!
@file dkcOSIndependent.c
@auther d
@
*/

#include "dkcOSIndependent.h"
#include "dkcDefined.h"

#include <assert.h>
#include <math.h>

int WINAPI dkcIsNativePathString(const char *s,size_t size){

	size_t i=0;
	if(s==NULL) return edk_FAILED;
	for(;i<size;i++){
		if(dkcmIS_INVALID_PATH_CHAR(s[i]))
		{
			return FALSE;
		}
	}
	return TRUE;
}


int WINAPI dkcErrorMessage(const char *expression,
										 const char *filename,size_t line,const char *message,...)
{
	char s[1024];
	char ss[1024 * 2];
	
	int va_list_result;
	va_list Valist;

	NULL_CHAR_ARRAY(s);
	NULL_CHAR_ARRAY(ss);
	
	if(message){
		SET_VA_LIST_C(Valist,va_list_result,s,sizeof(s),message);
	}else{
		//SET_VA_LIST(s,sizeof(s),"No message");
		_snprintf(s,sizeof(s),"No message\n");
	}

	_snprintf(ss,sizeof(ss),
		"DKUTIL_ASSERT(%s):\nfile:%s / \n line:%d / \n message: %s",
		expression,filename,line,s);



#ifdef NDEBUG//release
#	ifdef WIN32
		ODS(ss);
	//::MessageBox(NULL,ss,"ERROR ASSERTION !!",MB_OK);
	{
		LPCTSTR name="ERROR_TEMP.txt";
		{
			//t@CI[v
			FILE *fp;
			if(NULL != (fp = fopen( name , "at" ))){
			
				// G[Ot@Cɏo
				fputs( ss , fp ) ;
				fclose( fp ) ;
			}
		}
		ShellExecute(NULL, "open",name, NULL, NULL, SW_SHOWNORMAL);
		DeleteFile(name);
	}
	MB("̃eLXg̃\tg̊J҂ɓn΁AoŐߓȂ܂B\n \
		J҂ɒm点Ƃ͂̃eLXg]LĂ܂傤B");
	if(IDYES==MessageBox(NULL,
		"̂܂܂̃\tgNÂƁAXȂG[\܂B\nI܂H",
		"Ă͂Ȃ G[!!!",
		MB_YESNO))
	{
		exit(edk_FAILED);
		//terminate();
	}else{
	}
#	else	//else of win32
	
	fprintf(stderr,ss);
	exit(edk_FAILED);

#	endif //end of win32

#else //debug

#	ifdef WIN32
		ODS(ss);
	fprintf(stderr,ss);
	//_CrtDebugBreak();
	DebugBreak();
#	else //else of win32

	fprintf(stderr,ss);
	Debugger();

#	endif //end of win32
#endif//end of NDEBUG
	//assert(ss);
	
	return TRUE;
}
void* dkcAllocate(size_t size){
	void *ptr;
	ptr = malloc(size);
	if(NULL==ptr) return NULL;
	memset(ptr,0,size);
	return ptr;
}
int	dkcFree(void **p){
	if(!*p) return edk_FAILED;
	free(*p);
	*p = NULL;
	return edk_SUCCEEDED;
}
BOOL dkcIs_foepn_mode(const char *s){
	/* wrtb+ */
	const char *ms= "wrtb+";
	size_t slen = strlen(s);
	size_t mslen = strlen(ms);
	size_t i,j;
	int flag = FALSE;
	for(i=0;i<slen;i++){
		for(j=0;j<mslen;j++){
			if(ms[j]==s[i]){
				flag = TRUE;
				break;
			}
		}
		if(TRUE!=flag){
			return FALSE;
		}else{
			flag = FALSE;
		}
	}
	return TRUE;
}
/*
struct dkcDoublePoint{
	double x,y;
}DKC_DOUBLE_POINT;

int calc(DKC_DOUBLE_POINT *pa,size_t nums){
	pa->x	

}*/
/*
double calc(double StartX,double StartY,double EndX,double EndY)
{
	return	StartY - ((EndY - StartY) / (EndX - StartX)) * StartX;
}
*/
size_t dkcReallocateSizeFunction(size_t OldSize,size_t ExpandSize){
	//y=-25.43035 * pow(x,2) + 116.7214
	//y = -0.00000018 * pow(x,2) + 0.00019
	//y = -99.9999 * pow(OldSize,2) + 104857600;
	//y = 0.105263 * x * x + 10.52631
	//double x;
//	size_t size;
	if(OldSize <= 1024 * 5){//5KBȓȂ2{
		return OldSize * 2;
	}else if(OldSize >= 1024 * 1024 * 10 || 0==OldSize)
	{//10MBȏȂ + ExpandSize
		return OldSize + ExpandSize;
	}
	//ȊOȂExpandSize * 3
	return OldSize + ExpandSize * 3; 
	//return OldSize * 2;//Ђł֐B
}

int WINAPI dkcReallocate(void **NewPtr,size_t NewSize,
	void **OldPtr)
{
	return dkcReallocateEx(realloc,NewPtr,NewSize,OldPtr);
}

int WINAPI dkcReallocateEx(
	DKC_REALLOC_F_TYPE your_realloc,void **NewPtr,size_t NewSize,
	void **OldPtr
)
{
	void *ptr = NULL;

	if(NULL== your_realloc  /*|| NULL == *OldPtr ||
		0==OldSize*/
	){
		return edk_ArgumentException;//AzȁII
	}

	ptr = your_realloc(*OldPtr,NewSize);
	if(NULL==ptr) return edk_FAILED;

	//XV
	*OldPtr = NULL;
	*NewPtr = ptr;
	
	return edk_SUCCEEDED;
}



int WINAPI dkcReallocateAutoExpand(
	DKC_REALLOC_F_TYPE your_realloc,void **NewPtr,
	void **OldPtr,size_t OldSize,size_t *reallocated_size
	)
{
	void *ptr = NULL;
	size_t want_size = OldSize / 8;
	size_t ra_size = dkcReallocateSizeFunction(OldSize,
		 (want_size <= 20) ? 20 : want_size
	);
	size_t div = 8;
	size_t tmp_ra = ra_size / div;
	size_t i;
	if(NULL== your_realloc /*|| NULL==*NewPtr*/ || NULL == *OldPtr ||
		0==OldSize  || NULL==reallocated_size	
	){
		return edk_ArgumentException;//AzȁII
	}

	for(i=0;i<div;i++){
		ptr = your_realloc(*OldPtr,ra_size);
		if(NULL==ptr){
			if(OldSize > (ra_size -= tmp_ra)){//Ƃ肠tmp_raB
				break;//]݂Ȃ
			}
			continue;
		}else{
			break;
		}
	}
	if(NULL==ptr) return edk_FAILED;

	//XV
	*NewPtr = ptr;	
	*OldPtr = NULL;

	*reallocated_size = ra_size;

	return edk_SUCCEEDED;
}

static int WINAPI dkcLoadFile(void *data,size_t size,const char *fname,const char *mode,size_t *readsize){//="rb"
	FILE *fp ;
	if(NULL==readsize || NULL==data || NULL==fname || NULL==mode){
		return edk_FAILED;
	}
	fp = fopen( fname , mode ) ;//rb
	if(fp==NULL)return edk_FAILED;
	*readsize = fread( data , 1 , size , fp ) ;
	//fread( data , sizeof(size)  , 1 , fp ) ;
	fclose( fp ) ;

	return edk_SUCCEEDED;

}
static int WINAPI dkcSaveFile(const void *data,size_t size,const char *fname,const char *mode)
{
	FILE *fp;
	if(NULL==fname || NULL==mode){
		return edk_FAILED;
	}
	fp = fopen( fname , mode ) ;//wb
	if(fp==NULL) return edk_FAILED;
	fwrite( data , size  , 1 , fp ) ;
	//fwrite( data , sizeof(size)  , 1 , fp ) ;
	fclose( fp ) ;
	return edk_SUCCEEDED;
}


DKC_EXTERN FILE * WINAPI dkcFOpen(const char *filename,const char *mode){
	return fopen(filename,mode);
}

DKC_EXTERN int WINAPI dkcFClose(FILE **ptr){
	if(NULL==ptr || NULL==*ptr) return edk_ArgumentException;
	fclose(*ptr);
	*ptr = NULL;
	return edk_SUCCEEDED;
}
DKC_EXTERN size_t WINAPI dkcFReadAll(void *buffer,size_t size,FILE *fp)
{
	size_t count;
	size_t tc,tsize;
	BYTE *tbuffer;

	//read size
	tsize = size;
	//temp variable
	tc = 0;
	//offset counter
	count = 0;
	//byte type pointer
	tbuffer = (BYTE *)buffer;
	for(;;)
	{
		//error check
		if(ferror(fp) ){
			break;
		}
		if(feof(fp)){
			break;
		}
		//read
		tc = fread(&tbuffer[count],1,tsize,fp);
		//update
		tsize -= tc;
		count += tc;

		if(count == size){
			break;
		}
#	ifdef DEBUG
		//肦ȂG[`FbN
		dkcmNOT_ASSERT(count > size);
#	else
		if(count > size){
			break;
		}
#	endif
	}
	return count;
}

DKC_EXTERN size_t WINAPI dkcFWriteAll(void *buffer,size_t size,FILE *fp){
	size_t count;
	size_t tc,tsize;
	BYTE *tbuffer;

	//read size
	tsize = size;
	//temp variable
	tc = 0;
	//offset counter
	count = 0;
	//byte type pointer
	tbuffer = (BYTE *)buffer;
	for(;;)
	{
		//error check
		if(ferror(fp) ){
			break;
		}
		if(feof(fp)){
			break;
		}
		//read
		tc = fwrite(&tbuffer[count],1,tsize,fp);
		//update
		tsize -= tc;
		count += tc;

		if(count == size){
			break;
		}
#	ifdef DEBUG
		//肦ȂG[`FbN
		dkcmNOT_ASSERT(count > size);
#	else
		if(count > size){
			break;
		}
#	endif
	}
	return count;

}


//fopeñt@C֐găoCiZ[usB
int WINAPI dkcSaveBinary(const void *data,size_t size,const char *fname){//="wb"
	return dkcSaveFile(data,size,fname,"wb");
}

BOOL WINAPI dkcCreateEmptyFile(const char *filename){
	FILE *fp;
	fp = fopen( filename , "wb" ) ;//wb
	if(fp==NULL) return FALSE;
	fclose( fp ) ;
	return TRUE;
}


int WINAPI dkcLoadBinary(void *data,size_t size,const char *fname,size_t *readsize){//="rb"
	return dkcLoadFile(data,size,fname,"rb",readsize);
}

int WINAPI dkcSaveText(const char *text,size_t length,const char *fname){
	return dkcSaveFile(text,length,fname,"wt");
}
int WINAPI dkcLoadText(char *text,size_t length,const char *fname,size_t *readsize){
	return dkcLoadFile(text,length,fname,"rt",readsize);
}

void WINAPI dkcSwapFast(void *p1,void *p2,size_t size)
{
	void *p = malloc(size);
	dkcmNOT_ASSERT(NULL==p);
	memcpy(p,p1,size);
	memcpy(p1,p2,size);
	memcpy(p2,p,size);
	free(p);
}
/*
template<typename TYPE_T>
inline void dkcSwapT(TYPE_T *p1,TYPE_T *p2,size_t size){
	size_t i;
	char buf;
	size_t mod_ = size % sizeof(TYPE_T);
	size_t cnt = size / sizeof(TYPE_T);
	for(i=0;i<cnt;i++){
		SWAP_NUM(p1[i],p2[i]);
	}
	for(i=0;i<mod_;i++){
		buf = (((BYTE *)p1)[size - mod_ + i]);
		(((BYTE *)p1)[size - mod_ + i]) = 
			(((BYTE *)p2)[size - mod_ + i]) ;
		(((BYTE *)p2)[size - mod_ + i]) = buf;
	}

}


void WINAPI	dkcSwapFast(int *p1,int *p2,size_t size)
{
	size_t i;
	char buf;
	size_t mod_ = size % sizeof(int);
	size_t cnt = size / sizeof(int);
	for(i=0;i<cnt;i++){
		SWAP_NUM(p1[i],p2[i]);
	}
	for(i=0;i<mod_;i++){
		buf = (((BYTE *)p1)[size - mod_ + i]);
		(((BYTE *)p1)[size - mod_ + i]) = 
			(((BYTE *)p2)[size - mod_ + i]) ;
		(((BYTE *)p2)[size - mod_ + i]) = buf;
	}
}*/

#ifdef _MSC_VER
#	pragma warning(disable:4244)
#endif

void WINAPI dkcSwap64(ULONGLONG *p1,ULONGLONG *p2,size_t size){
	size_t i;
	BYTE buf;
	size_t mod_ = size % sizeof(ULONGLONG);
	size_t cnt = size / sizeof(ULONGLONG);
	//char *tp1 = (char *)p1,*tp2 = (char *)p2;
	for(i=0;i<cnt;i++){
		SWAP_NUM(p1[i],p2[i]);
	}
	for(i=0;i<mod_;i++){
		
		//SWAP_NUM((char)tp1[size - mod_ + 1],(char)tp2[size - mod_ + i]);
		/*a = b - a ;\
    b -= a ;\
    a += b
		*/
		/*( ( ((char *) p2)[size - mod_ + i]))
			= (char)( ( ((char *) p2)[size - mod_ + i])) - 
			(char)( ( ((char *) p1)[size - mod_ + i]));
		
		( ( ((char *) p2)[size - mod_ + i])) -= ( ( ((char *) p1)[size - mod_ + i]));

		( ( ((char *) p1)[size - mod_ + i])) += ( ( ((char *) p2)[size - mod_ + i]));
			*/
		
		
		buf = (((BYTE *)p1)[size - mod_ + i]);
		(((BYTE *)p1)[size - mod_ + i]) = 
			(((BYTE *)p2)[size - mod_ + i]) ;
		(((BYTE *)p2)[size - mod_ + i]) = buf;
		
	}

}

void WINAPI dkcSwap(void *p1,void *p2,size_t size)
{
	dkcSwap64((ULONGLONG *)p1,(ULONGLONG *)p2,size);
}



void WINAPI dkcTwoDWORDToULONGLONG(ULONGLONG *dest,DWORD high,DWORD low){
	//*dest = (ULONGLONG)((high << 32) + low);
	*dest = (ULONGLONG)high << 32;
	*dest += low;
		//( high * MAXDWORD ) + low;
}

void WINAPI dkcULONGLONGToTwoDWORD(DWORD *dhigh,DWORD *dlow,ULONGLONG src){
	DWORD *o = (DWORD *)&src;
	dkcmNOT_ASSERT(sizeof(DWORD) * 2 != sizeof(ULONGLONG));
	//GfBAǂɂ悤I
	*dhigh = o[0];
	*dlow = o[1];
}


#ifdef _MSC_VER
#	pragma warning(default:4244)

#include <crtdbg.h>

void WINAPI dkcCheckMemoryLeak(BOOL flag){
	if(flag){
		_CrtSetDbgFlag(_CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF);
	}else{
		_CrtSetDbgFlag(_CRTDBG_CHECK_ALWAYS_DF);
	}
}

#else

void WINAPI dkcCheckMemoryLeak(BOOL flag){

}
#endif

const char *WINAPI dkcGetPathSep(){
#ifdef WIN32
	static char target[3]={dkcdPATH_SEP,'/','\0'};
#else
	static char target[3]={dkcdPATH_SEP,'\0'};
#endif
	return target;
}
#ifdef _MSC_VER
BOOL WINAPI dkcIsMMX(void)
{
	BOOL flag = FALSE;

	__asm{
		push	edx
		push	ecx
		pushfd
		pop		eax
		xor		eax, 00200000h
		push	eax
		popfd
		pushfd
		pop		ebx
		cmp		eax, ebx
		jnz		non_mmx
		mov		eax, 0
		cpuid
		cmp		eax, 0
		jz		non_mmx
		mov		eax, 1
		cpuid
		and		edx, 00800000h
		jz		non_mmx
		mov		flag, TRUE
	non_mmx:
		pop		ecx
		pop		edx
	}
	return flag;
}
#else
BOOL WINAPI dkcIsMMX(void){
  return FALSE;
}
#endif


DKC_INLINE USHORT dkcReverseEndian16(USHORT x){
	return (USHORT)((x >> 8) | (x << 8));
}

DKC_INLINE DWORD dkcReverseEndian32(DWORD x){
	return (x << 24) | ((x & 0x0000ff00) << 8) | ((x & 0x00ff0000) >> 8) | (x >> 24);
}

DKC_INLINE ULONGLONG dkcReverseEndian64(ULONGLONG x) {

	return (
		(ULONGLONG)dkcReverseEndian32((DWORD)(x & 0x00000000ffffffff)) << 32)
		| 
		dkcReverseEndian32((DWORD)(x >> 32)
	);

}
DKC_INLINE  BOOL dkcIsLittleEndian(){
	int x=1;
	return (BOOL)((*(char*)&x));
}


static void *get_offset(void *p,size_t offset){
	BYTE *oo = (BYTE *)p;
	
	return (void *)&(oo[offset]);
}

/*!
n:z̍đ䐔
k:ׂԍij
@return offset number ,Error : UINT_MAX
*/
int WINAPI dkcSelect(void *dest,const void *a_src,size_t n,int k,size_t width ,DKC_COMPARE_TYPE less)
{

	int i,j,left, right;

	void *x = malloc(width);
	void *a = malloc(n * width);
	if(NULL==x || NULL==a){
		return edk_ArgumentException;
	}
	if(n > INT_MAX){
		return edk_FAILED;
	}
	

	memcpy(a,a_src,width * n);


	left = 0;  right = n - 1;

	while (left < right) 
	{

		memcpy(x,	(const void *)get_offset(a,k * width),width);
		i = left;
		j = right;

		for ( ; ; ) {

			while( less(get_offset(a,i * width),x) > 0){
			//while( *(int *)get_offset(a,i * width) < *(int *)x){
				i++;
			}

			while( less(x,get_offset(a,j * width)) > 0){
			//while( *(int *)x < *(int *)get_offset(a,j * width) ){
				j--;
			}

			if (i > j){
				break;
			}
			

			dkcSwapFast(
				get_offset(a,i * width),
				get_offset(a,j * width),
				width
				);
			
			i++;
			j--;
		}
		if (j < k){
			left  = i;
		}
		if (k < i){
			right = j;
		}
	}

	//Qbg
	{
		//printf("%d",*(int *)get_offset(a,k * width));

		memcpy(dest,(const void *)get_offset(a,k * width),width);

	}
	free(x);
	free(a);

	return edk_SUCCEEDED;

}


DKC_INLINE int WINAPI dkcSelectMax(void *a,const void *a_src, size_t n,size_t width ,DKC_COMPARE_TYPE less){
	if(n-1 > INT_MAX){
		return edk_FAILED;
	}
	return dkcSelect(a,a_src,n,(int)n-1,width,less);
}
DKC_INLINE int WINAPI dkcSelectMin(void *a,const void *a_src, size_t n,size_t width ,DKC_COMPARE_TYPE less){
	return dkcSelect(a,a_src,n,(int)0,width,less);
}
#if 0
int WINAPI dkcSelect(void *dest,const void *a_src,size_t n,size_t k,size_t width ,DKC_COMPARE_TYPE less)
{
	//int i, j, left, right;
	size_t i,j,left, right;
	//keytype x, t;
	//size_t x,t;
	void *x = malloc(width);
	void *a = malloc(n * width);
	if(NULL==x || NULL==a){
		return edk_ArgumentException;
	}
	
	//void *t = malloc(width);
	memcpy(a,a_src,width * n);


	left = 0;  right = n - 1;
	/*
	x = a[k];  i = left;  j = right;
		for ( ; ; ) {
			while (a[i] < x) i++;
			while (x < a[j]) j--;
			if (i > j) break;
			t = a[i];  a[i] = a[j];  a[j] = t;
			i++;  j--;
		}
		if (j < k) left  = i;
		if (k < i) right = j;
	*/
	while (left < right) 
	{
		//x = a[k];  i = left;  j = right;
		//offset_temp = (BYTE *)a;
	
		//memcpy(x,	(const void *)&offset_temp[k * width],width);
		memcpy(x,	(const void *)get_offset(a,k * width),width);
		i = left;
		j = right;

		for ( ; ; ) {
			//while (a[i] < x) i++;
			//while(less(a[i],x)) i++;
//#error less Ȃ greater łAqsortƓdlɂ邽ߥBX}
			//while( less(get_offset(a,i * width),x) < 0){
			while( less(get_offset(a,i * width),x) ){
				i++;
			}

			/*void *p = get_offset(a,i * width);
			BYTE *ma = (BYTE *)get_offset(a,n * width);
			dkcmNOT_ASSERT(p < a);
			dkcmNOT_ASSERT(p > ((BYTE *)a) + n * width);
			dkcmNOT_ASSERT((ma - (BYTE *)p) % width != 0);
			while(less(p,x) > 0){
				i++;
				p = get_offset(a,i * width);
				ma = (BYTE *)get_offset(a,n * width);
				dkcmNOT_ASSERT(p < a);
				dkcmNOT_ASSERT(p > ma - width);
				dkcmNOT_ASSERT((ma - p) % width != 0);
			}*/

			//while (x < a[j]) j--;
			//while(less(x,a[j]) j--;
			//while( less(x,get_offset(a,j * width)) < 0){
			while( less(x,get_offset(a,j * width)) ){
				j--;
			}

			if (i > j){
				break;
			}
			
			//t = a[i];  a[i] = a[j];  a[j] = t;
			//dkcSwap(&a[i],&a[j],width);
			dkcSwap(
				get_offset(a,i * width),
				get_offset(a,j * width),
				width
				);
			
			i++;
			j--;
		}
		if (j < k){
			left  = i;
		}
		if (k < i){
			right = j;
		}
	}

	//Qbg
	{
		printf("%d",*(int *)get_offset(a,k * width));
		//memcpy(,	(const void *)get_offset(a,k * width),width);
		//memcpy(dest,(const void *)get_offset(a,k * width),width);
		memcpy(dest,x,width);
	}
	free(x);
	free(a);
	//free(t);
	return edk_SUCCEEDED;
	//return a[k];
}
#endif