
/*!
@file dkcMD5.c
@brief MD5 hash algorithm
@note
original: http://sourceforge.net/projects/libmd5-rfc/
reconstruct: d

*/

#include "dkcMD5.h"
#include "dkcStdio.h"


DKC_MD5 *WINAPI dkcAllocMD5(){
	DKC_MD5 *p = dkcAllocate(sizeof(DKC_MD5));
	if(NULL==p){
		return NULL;
	}
	dkcMD5Init(p);
	return p;
}

void WINAPI dkcMD5Init(DKC_MD5 *p){
	md5_init(&(p->d));
	p->mFinalized = FALSE;
}

int WINAPI dkcMD5Load(DKC_MD5 *p,const BYTE *pBuffer,DWORD dwSize){
	if(dwSize > INT_MAX){
		return edk_FAILED;
	}

	dkcMD5LoadStandard(p,pBuffer,dwSize);
	return edk_SUCCEEDED;
}

void WINAPI dkcMD5LoadStandard(DKC_MD5 *p,const BYTE *pBuffer,DWORD dwSize){
	if(p->mFinalized){
		return;
	}
	md5_append(&(p->d),pBuffer,(int)dwSize);
}



void WINAPI dkcMD5Final(DKC_MD5 *p){
	if(p->mFinalized){
		return;
	}
	md5_finalize(&(p->d));

	p->mFinalized = TRUE;
}

int WINAPI dkcMD5Digest(DKC_MD5 *p,BYTE *buff,size_t size){
	if(size < 16){
		return edk_BufferOverFlow;
	}
	//buff̃LXgoOȂB
	md5_get_digest(&(p->d),(BYTE *)buff);
	return edk_SUCCEEDED;
}

int WINAPI dkcMD5DigestStr(DKC_MD5 *p,char *buff,size_t size){
	if(size < 32 + 1){
		return edk_BufferOverFlow;
	}
	md5_get_str_digest(&(p->d),(char *)buff);
	return edk_SUCCEEDED;
}

int WINAPI dkcMD5FinalDigestStr(DKC_MD5 *p,char *buff,size_t size){
	dkcMD5Final(p);
	return dkcMD5DigestStr(p,buff,size);
}

int WINAPI dkcMD5FinalDigest(DKC_MD5 *p,BYTE *buff,size_t size){
	dkcMD5Final(p);
	return dkcMD5Digest(p,buff,size);

}


int WINAPI dkcFreeMD5(DKC_MD5 **p){
	if(NULL==p){
		return edk_FAILED;
	}
	return dkcFree(p);
}