/*!
@file dkcLZSS.h
@since 2004/04/20
@auther Original:Lee Noriyuki / Reconstruction:d
@brief LZSSk

*/
#ifndef dkutil_c_LZSS__h
#define dkutil_c_LZSS__h


#include "dkcOSIndependent.h"

///< obt@̑傫
#define LZSS_RING_LENGTH		4096
///< obt@̃}XN
#define LZSS_RING_MASK			(LZSS_RING_LENGTH-1)
///< Œv
#define LZSS_LONGEST_MATCH		16
///LZSS̃VOl`iύXĂv`i))
#define dkcdLZSS_SIGNATURE 'LZSS'

typedef struct dkc_LZSS
{
	///< k𓀗p[Nf[^|C^
	long Dad[LZSS_RING_LENGTH+1];								
	///< k𓀗p[Nf[^|C^
	long LSon[LZSS_RING_LENGTH+1];								
	///< k𓀗p[Nf[^|C^
	long RSon[LZSS_RING_LENGTH+257];								

	///< Œvʒu
	long MatchPos;												
	///< Œv
	long MatchLen;													
	///< eLXgf[^|C^
	unsigned char Text[LZSS_RING_LENGTH + LZSS_LONGEST_MATCH - 1];
}DKC_LZSS;

typedef struct dkc_LZSS_Header{
	unsigned long mSignature;
	///̃TCY
	size_t mOriginSize;
	///kTCY
	size_t mCompressedSize;

}DKC_LZSS_HEADER;


DKC_EXTERN DKC_LZSS *WINAPI dkcAllocLZSS();

DKC_EXTERN int WINAPI dkcFreeLZSS(DKC_LZSS **);
/*!
@param ptr[in][out] dkcAllocLZSS()Ŏ擾|C^
@param ph[out] DKC_LZSS_HEADERւ̃|C^
@param dest[out] fR[hꂽf[^̏oobt@ւ̃|C^
@param dsize[in] dest̃TCY
@param src[in] obt@ւ̃|C^
@param ssize[in] src̃TCY
@param sig[in] dkcLZSSEncode()̎Aw肵VOl`ID
@return edk_Result̂ǂꂩԂB
@note
DKC_LZSS_HEADER̃omOriginSizedsizeƂ̊֐͎s܂B
*/
DKC_EXTERN int WINAPI dkcLZSSDecode(DKC_LZSS *ptr,DKC_LZSS_HEADER *ph,
	BYTE *dest,size_t dsize,const BYTE *src,size_t ssize,ULONG sig);
/*!
@param ptr[in][out] dkcAllocLZSS()Ŏ擾|C^
@param ph[out] DKC_LZSS_HEADERւ̃|C^
@param dest[out] LZSSňkꂽf[^̏oobt@ւ̃|C^
@param dsize[in] dest̃TCY
@param src[in] obt@ւ̃|C^
@param ssize[in] src̃TCY
@param CloseProcessSize[in] ł؂ɂTCY dsize菬̂ZI[
@param sig[in] LZSSƏؖVOl`
@return edk_Result̂ǂꂩԂBk鉿l̖ꍇedk_NoValueToProcessԂB
*/
DKC_EXTERN int WINAPI dkcLZSSEncode(DKC_LZSS *ptr,DKC_LZSS_HEADER *ph,
	BYTE *dest,size_t dsize,const BYTE *src,size_t ssize,
	size_t CloseProcessSize,ULONG sig);

//headerLZSS̃VOl`ǂmF @return TRUELZSSf[^ƎvB
//p~FVOl`͎Rɐݒł悤ɁII
//DKC_EXTERN BOOL WINAPI dkcLZSSIsLZSS(DKC_LZSS_HEADER *p);


#endif