/*!
@file dkcBlowfish.h
@brief Blowfish encryptio algorithm
@auther converted C by d
@since 2004/07/07
@note
Bruce SchneierAJim CongerɊӂ܂B
*/



#ifndef dkutil_c_Blowfish
#define dkutil_c_Blowfish

#include "dkcOSIndependent.h"

#define MAXKEYBYTES 	56		// 448 bits max
#define NPASS           16		// SBox passes

///L[̍ől
#define dkcd_BLOWFISH_MAX_KEY_SIZE MAXKEYBYTES

#ifndef DWORD
#define DWORD  		unsigned long
#endif
#ifndef WORD
#define WORD  		unsigned short
#endif
#ifndef BYTE
#define BYTE  		unsigned char
#endif


typedef DWORD		(*DKC_BLOWFISH_SBOX_TYPE)[256];

typedef struct dkc_Blowfish{
	DWORD 		* PArray ;
	//DWORD		(* SBoxes)[256];
	DKC_BLOWFISH_SBOX_TYPE SBoxes;
}DKC_BLOWFISH;

/*!
@param key[in] L[ւ̃|C^
@param keysize[in] keỹTCY
@note
dkcd_BLOWFISH_MAX_KEY_SIZEL[傫ꍇ͎s܂B
dkcBlowfishInit()ĂяoĂ܂B
*/
DKC_EXTERN DKC_BLOWFISH *WINAPI dkcAllocBlowfish(BYTE *key,int keysize);

///dkcAllocBlowfish()Ŋmۂ̈J
DKC_EXTERN int WINAPI dkcFreeBlowfish(DKC_BLOWFISH **);
/*!
@note
- dkcd_BLOWFISH_MAX_KEY_SIZEL[傫ꍇ͎s܂B
- ̊֐̎gp͏コĂ܂B
- ̊֐̖O͕ύXꍇ܂B
@return edk_SUCCEEDEDȂ琬
*/
///dkcAllocBlowfish()ŏ邯ǁAIɏꍇĂяoB
DKC_EXTERN int WINAPI dkcBlowfishInit(DKC_BLOWFISH *p,BYTE *key, int keybytes);


DWORD WINAPI dkcBlowfishGetOutputLength (DWORD lInputLong);
/*!
Encode pIntput into pOutput.  Input length in lSize.  Returned value
is length of output which will be even MOD 8 bytes.  Inputbuffer and
output buffer can be the same, but be sure buffer length is even MOD8.
*/
DKC_EXTERN DWORD WINAPI dkcBlowfishEncrypt(DKC_BLOWFISH *p,BYTE * pInput, BYTE * pOutput, DWORD lSize);
/*!
 Decode pIntput into pOutput.  Input length in lSize.  Inputbuffer and
 output buffer can be the same, but be sure buffer length is even MOD8.
*/
DKC_EXTERN void WINAPI dkcBlowfishDecrypt (DKC_BLOWFISH *p,BYTE * pInput, BYTE * pOutput, DWORD lSize);




/// choose a byte order for your hardware
#define ORDER_DCBA	// chosing Intel in this case

#ifdef ORDER_DCBA  	// DCBA - little endian - intel
	union aword {
	  DWORD dword;
	  BYTE byte [4];
	  struct {
	    unsigned int byte3:8;
	    unsigned int byte2:8;
	    unsigned int byte1:8;
	    unsigned int byte0:8;
	  } w;
	};
#endif

#ifdef ORDER_ABCD  	// ABCD - big endian - motorola
	union aword {
	  DWORD dword;
	  BYTE byte [4];
	  struct {
	    unsigned int byte0:8;
	    unsigned int byte1:8;
	    unsigned int byte2:8;
	    unsigned int byte3:8;
	  } w;
	};
#endif

#ifdef ORDER_BADC  	// BADC - vax
	union aword {
	  DWORD dword;
	  BYTE byte [4];
	  struct {
	    unsigned int byte1:8;
	    unsigned int byte0:8;
	    unsigned int byte3:8;
	    unsigned int byte2:8;
	  } w;
};
#endif


#endif //end of include once