/*!
@file dkcArcfour.h
@brief RC4݊ASY Arcfour
*/
#ifndef dkutil_c_Arcfour
#define dkutil_c_Arcfour

#include "dkcOSIndependent.h"


//**********************************************************
//RC4݊ASY Arcfour
//QlF
//http://www21.ocn.ne.jp/~k-west/SSLandTLS/draft-kaukonen-cipher-arcfour-03-Ja.txt
//**********************************************************

///arcfour algprithm state (RC4݊̃ASY
typedef struct dkc_Arcfour_State{
	unsigned char mi;
	unsigned char mj;
	unsigned char msbox[256];
}DKC_ARCFOUR_STATE;

/*!
@param key[in] keyւ̃|C^
@param keylen[in] keỹTCY
@return DKC_ARCFOUR_STATE \̂ւ̃|C^
@note
gIdkcFreeArcfourg܂傤B
*/
DKC_EXTERN DKC_ARCFOUR_STATE * WINAPI dkcAllocArcfour(const unsigned char *key,size_t keylen);

/*!
@param dkcAllocArcfourŊmۂ̈ւ̃|C^ւ̃|C^
@return edk_SUCCEEDEDŐ
*/
DKC_EXTERN int WINAPI dkcFreeArcfour(DKC_ARCFOUR_STATE **p);

/*!
@param p[in][out] dkcAllocArcfour()Ŋmۂ̈ւ̃|C^
@return XORׂl
*/
DKC_EXTERN unsigned char WINAPI dkcArcfourByte(DKC_ARCFOUR_STATE *p);
/*!
@param p[in] dkcAllocArcfour()Ŋmۂ̈ւ̃|C^
@param dest[in] o̓obt@ւ̃|C^
@param destsize[in] dest̃TCY
@param src[in] ̓obt@ւ̃|C^
@param srcsize[in] src̃TCY
@return edk_SUCCEEDED Ő
*/
DKC_EXTERN int WINAPI dkcArcfourEncrypt(DKC_ARCFOUR_STATE *p,
	unsigned char *dest,size_t destsize,
	const unsigned char *src,size_t srcsize);

DKC_EXTERN void WINAPI dkcArcfourEncryptNoDest(DKC_ARCFOUR_STATE *p,
	unsigned char *dest_and_src,size_t dest_and_srcsize);	

#define dkcArcfourDecrypt(p,dest,destsize,src,srcsize) \
	dkcArcfourEncrypt(p,dest,destsize,src,srcsize)

#define dkcArcfourDecryptNoDest(p,dest_and_src,dest_and_srcsize) \
	dkcArcfourEncryptNoDest(p,dest_and_src,dest_and_srcsize)


#endif //end of include once